/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy.common;

import de.intarsys.security.signature.policy.CommonQualifierFactory;
import de.intarsys.security.signature.policy.NoticeReference;
import de.intarsys.security.signature.policy.common.SPUserNoticeQualifier;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;

public class SPUserNoticeQualifierFactory
extends CommonQualifierFactory<SPUserNoticeQualifier> {
    public static final String ARG_NOTICEREFERENCE = "noticeReference";
    public static final String ARG_EXPLICITTEXT = "explicitText";
    public static final String ARG_ORGANIZATION = "organization";
    public static final String ARG_NOTICENUMBERS = "noticeNumbers";

    @Override
    protected String getOID() {
        return "1.2.840.113549.1.9.16.5.2";
    }

    public Class<SPUserNoticeQualifier> getResultType() {
        return SPUserNoticeQualifier.class;
    }

    protected SPUserNoticeQualifier basicCreateInstance(IArgs args) throws ObjectCreationException {
        String explicitText = ArgTools.getString((IArgs)args, (String)ARG_EXPLICITTEXT, null);
        NoticeReference noticeReference = null;
        IArgs aNoticeReference = ArgTools.getArgs((IArgs)args, (String)ARG_NOTICEREFERENCE, null);
        if (aNoticeReference != null) {
            String organization = ArgTools.getString((IArgs)aNoticeReference, (String)ARG_ORGANIZATION, null);
            IArgs aNoticeNumbers = ArgTools.getArgs((IArgs)aNoticeReference, (String)ARG_NOTICENUMBERS, (IArgs)Args.create());
            int[] noticeNumbers = new int[aNoticeNumbers.size()];
            int index = 0;
            Iterator i = aNoticeNumbers.bindings();
            while (i.hasNext()) {
                IArgs.IBinding binding = (IArgs.IBinding)i.next();
                try {
                    noticeNumbers[index] = (Integer)ConverterRegistry.get().convert(binding.getValue(), Integer.class);
                }
                catch (ConversionException e) {
                    throw new ObjectCreationException((Throwable)e);
                }
                ++index;
            }
            noticeReference = new NoticeReference(organization, noticeNumbers);
        }
        return new SPUserNoticeQualifier(noticeReference, explicitText);
    }
}

