/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy;

import de.intarsys.asn1.policy.SignPolicyInfo;
import de.intarsys.asn1.policy.SignatureValidationPolicy;
import de.intarsys.asn1.policy.SigningPeriod;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.policy.PACKAGE;
import de.intarsys.security.signature.policy.asn1.ASN1SignaturePolicy;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Date;

public class ASN1SignaturePolicyValidator
implements IReviewer<ISignatureEntry, IVSSignatureEntry> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private ASN1SignaturePolicy policy;

    public ASN1SignaturePolicyValidator(ASN1SignaturePolicy policy) {
        this.policy = policy;
    }

    public IVSSignatureEntry checkSignatureValidationPolicy(ISignatureEntry signatureEntry, VSSignatureEntry state, IValidationParameters params, SignatureValidationPolicy signatureValidationPolicy) {
        VSSignatureEntry result = new VSSignatureEntry(signatureEntry, -1);
        SigningPeriod signingPeriod = signatureValidationPolicy.getSigningPeriod();
        Date referenceDate = params.getDateToTest();
        if (referenceDate.before(signingPeriod.getNotBefore())) {
            state.invalidate(Msg.getString("ASN1SignaturePolicyValidator.PolicyNotYetApplicable", new Object[0]));
        }
        if (referenceDate.after(signingPeriod.getNotAfter())) {
            state.invalidate(Msg.getString("ASN1SignaturePolicyValidator.PolicyNoMoreApplicable", new Object[0]));
        }
        return result;
    }

    public ASN1SignaturePolicy getPolicy() {
        return this.policy;
    }

    protected SignPolicyInfo getPolicyInfo() {
        return this.getPolicy().getSignPolicyInfo();
    }

    @Override
    public IVSSignatureEntry review(ISignatureEntry signatureEntry, IVSSignatureEntry state, IValidationParameters params) {
        VSSignatureEntry result = new VSSignatureEntry(signatureEntry, -1);
        this.checkSignatureValidationPolicy(signatureEntry, result, params, this.getPolicyInfo().getSignatureValidationPolicy());
        return result;
    }
}

