/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ocsp.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.IOCSPSingleResult;
import de.intarsys.security.ocsp.common.SingleResult;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.hex.HexTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPResponse
implements IOCSPResponse,
IAdapterSupport {
    private static final Logger Log = LoggerFactory.getLogger(OCSPResponse.class);
    private final BasicOCSPResp resp;
    private final SingleResp[] responses;

    public static byte[] getDigesterData(PublicKey key) throws IOException {
        ASN1Primitive obj = ASN1Tools.create((byte[])key.getEncoded());
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)obj);
        ASN1BitString bitString = keyInfo.getPublicKeyData();
        return bitString.getBytes();
    }

    public OCSPResponse(BasicOCSPResp resp) {
        this.resp = resp;
        this.responses = resp.getResponses();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OCSPResponse)) {
            return false;
        }
        OCSPResponse otherResponse = (OCSPResponse)other;
        return this.resp.equals((Object)otherResponse.resp);
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (BasicOCSPResp.class == clazz) {
            return (T)this.getResp();
        }
        return null;
    }

    @Override
    public Date getArchiveCutoff() {
        try {
            ASN1Primitive derCutoff = CertificateTools.getExtensionValue(this, "1.3.6.1.5.5.7.48.1.6");
            ASN1GeneralizedTime cutoff = ASN1GeneralizedTime.getInstance((Object)derCutoff);
            if (cutoff == null) {
                return null;
            }
            return cutoff.getDate();
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public IX509PublicKeyCertificate[] getCertificates() throws CertificateException, IOException {
        return CertificateTools.wrapCertificateHolders(this.getResp().getCerts());
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        HashSet<String> result = new HashSet<String>();
        for (ASN1ObjectIdentifier oid : this.resp.getCriticalExtensionOIDs()) {
            result.add(oid.getId());
        }
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        BasicOCSPResp resp = this.getResp();
        if (resp == null) {
            return null;
        }
        return resp.getEncoded();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        try {
            Extension extension = this.resp.getExtension(new ASN1ObjectIdentifier(oid));
            if (extension == null) {
                return null;
            }
            return extension.getExtnValue().getEncoded("DER");
        }
        catch (IOException e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
    }

    public Object getImpl() {
        return this.getResp();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        HashSet<String> result = new HashSet<String>();
        for (ASN1ObjectIdentifier oid : this.resp.getNonCriticalExtensionOIDs()) {
            result.add(oid.getId());
        }
        return result;
    }

    @Override
    public Date getProducedAt() {
        BasicOCSPResp resp = this.getResp();
        if (resp == null) {
            return null;
        }
        return resp.getProducedAt();
    }

    @Override
    public String getReponderId() {
        BasicOCSPResp resp = this.getResp();
        if (resp == null) {
            return null;
        }
        RespID respID = resp.getResponderId();
        if (respID == null) {
            return null;
        }
        ResponderID responderID = respID.toASN1Primitive();
        if (responderID == null) {
            return null;
        }
        ASN1TaggedObject tagged = ASN1TaggedObject.getInstance((Object)responderID.toASN1Primitive());
        if (tagged == null) {
            return null;
        }
        switch (tagged.getTagNo()) {
            case 1: {
                X509Name name = X509Name.getInstance((Object)tagged.getBaseObject());
                return name.toString();
            }
            case 2: {
                DEROctetString octets = (DEROctetString)DEROctetString.getInstance((Object)tagged.getBaseObject());
                try {
                    byte[] keyHash = ASN1Tools.getASN1OctetStringOctets((byte[])octets.getOctets());
                    return HexTools.bytesToHexString((byte[])keyHash);
                }
                catch (IOException e) {
                    return "???";
                }
            }
        }
        return null;
    }

    public BasicOCSPResp getResp() {
        return this.resp;
    }

    @Override
    public byte[] getSignature() {
        BasicOCSPResp resp = this.getResp();
        if (resp == null) {
            return null;
        }
        return resp.getSignature();
    }

    @Override
    public String getSignatureAlgorithm() {
        BasicOCSPResp resp = this.getResp();
        if (resp == null) {
            return null;
        }
        String oid = resp.getSignatureAlgOID().getId();
        Provider prov = Security.getProvider("BC");
        String algName = prov.getProperty("Alg.Alias.Signature." + oid);
        if (algName != null) {
            return algName;
        }
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            algName = provs[i].getProperty("Alg.Alias.Signature." + oid);
            if (algName == null) continue;
            return algName;
        }
        return oid;
    }

    @Override
    public IOCSPSingleResult getSingleResult(IX509Certificate certificate, IX509PublicKeyCertificate issuer) {
        if (this.responses == null) {
            return null;
        }
        for (int i = 0; i < this.responses.length; ++i) {
            SingleResp resp = this.responses[i];
            CertificateID id = resp.getCertID();
            try {
                if (id == null || !this.match(id, certificate, issuer)) continue;
                return new SingleResult(resp, certificate);
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public int getVersion() {
        BasicOCSPResp resp = this.getResp();
        if (resp == null) {
            return 1;
        }
        return resp.getVersion();
    }

    public int hashCode() {
        return this.resp.hashCode();
    }

    public boolean hasStatusOfCertificate(IX509Certificate certificate, IX509PublicKeyCertificate issuer) {
        return this.getSingleResult(certificate, issuer) != null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.resp.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    public boolean isAllCertificatesGood() {
        if (this.responses == null) {
            return true;
        }
        for (int i = 0; i < this.responses.length; ++i) {
            SingleResp resp = this.responses[i];
            if (!(resp.getCertStatus() instanceof UnknownStatus) && !(resp.getCertStatus() instanceof RevokedStatus)) continue;
            return false;
        }
        return true;
    }

    public boolean match(CertificateID id, IX509Certificate certificate, IX509PublicKeyCertificate issuer) throws IOException, NoSuchAlgorithmException {
        byte[] key;
        IDigest providedDigest;
        IDigest providedDigest2;
        IDigest refDigest;
        BigInteger serial = id.getSerialNumber();
        if (serial != null && !serial.equals(certificate.getSerialNumber())) {
            return false;
        }
        byte[] issuerKeyHash = id.getIssuerKeyHash();
        byte[] issuerNameHash = id.getIssuerNameHash();
        String hashAlgOID = id.getHashAlgOID().getId();
        if ((issuerNameHash != null || issuerKeyHash != null) && hashAlgOID == null) {
            return false;
        }
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(hashAlgOID);
        if (algorithm == null) {
            throw new NoSuchAlgorithmException(hashAlgOID);
        }
        IDigester digester = DigestTools.createDigester((String)algorithm.getName());
        if (issuerNameHash != null && !(refDigest = DigestTools.createDigest((String)algorithm.getName(), (byte[])issuerNameHash)).equals(providedDigest2 = digester.digest(issuer.getSubjectX500Principal().getEncoded()))) {
            return false;
        }
        return issuerKeyHash == null || (refDigest = DigestTools.createDigest((String)algorithm.getName(), (byte[])issuerKeyHash)).equals(providedDigest = digester.digest(key = OCSPResponse.getDigesterData(issuer.getPublicKey())));
    }
}

