/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.keystore.outlet;

import de.intarsys.security.keystore.outlet.IKeyStoreOutlet;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public class DefaultKeyStoreOutlet
implements IKeyStoreOutlet {
    private Map cache = new HashMap();

    @Override
    public KeyStore lookupKeyStore(File file, String type) throws GeneralSecurityException, IOException {
        Entry entry;
        if (!file.isFile()) {
            return null;
        }
        if (type == null) {
            type = "JKS";
        }
        if ((entry = (Entry)this.cache.get(file)) == null) {
            entry = new Entry(file, type);
            this.cache.put(file, entry);
        }
        return entry.getKeyStore();
    }

    private static class Entry {
        private File file;
        private String type;
        private SoftReference keyStore;
        private Exception keyStoreEx;
        private long lastModified;

        public Entry(File file, String type) {
            this.file = file;
            this.type = type;
        }

        protected void checkKeyStoreEx() throws IOException, GeneralSecurityException {
            if (this.keyStoreEx != null) {
                if (this.keyStoreEx instanceof IOException) {
                    throw (IOException)this.keyStoreEx;
                }
                if (this.keyStoreEx instanceof GeneralSecurityException) {
                    throw (GeneralSecurityException)this.keyStoreEx;
                }
                throw new IOException(this.keyStoreEx);
            }
        }

        public KeyStore getKeyStore() throws GeneralSecurityException, IOException {
            KeyStore ks = null;
            if (this.keyStore != null) {
                ks = (KeyStore)this.keyStore.get();
                if (this.file.lastModified() > this.lastModified) {
                    ks = null;
                    this.keyStore = null;
                    this.keyStoreEx = null;
                }
            }
            if (ks == null) {
                this.checkKeyStoreEx();
                try {
                    ks = this.loadKeyStore();
                    this.keyStore = new SoftReference<KeyStore>(ks);
                }
                catch (Exception e) {
                    this.keyStoreEx = e;
                }
                this.checkKeyStoreEx();
            }
            return ks;
        }

        protected KeyStore loadKeyStore() throws GeneralSecurityException, IOException {
            KeyStore keystore = null;
            FileInputStream input = null;
            try {
                this.lastModified = this.file.lastModified();
                input = new FileInputStream(this.file);
                keystore = KeyStore.getInstance(this.type);
                keystore.load(input, null);
            }
            catch (Throwable throwable) {
                StreamTools.close(input);
                throw throwable;
            }
            StreamTools.close((Closeable)input);
            return keystore;
        }
    }
}

