/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Mac;

public class MacOutputStream
extends FilterOutputStream {
    private final Mac mac;

    public MacOutputStream(OutputStream out, Mac mac) {
        super(out);
        this.mac = mac;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.out != null) {
            this.out.write(b);
        }
        this.mac.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        this.mac.update(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.out != null) {
            super.write(b);
        }
        this.mac.update((byte)b);
    }
}

