/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import org.bouncycastle.asn1.x509.BasicConstraints;

public class X509ExtensionBasicConstraints
extends CommonX509Extension {
    public static final String OID = "2.5.29.19";
    private boolean ca;

    public static X509ExtensionBasicConstraints create(byte[] encoded) throws IOException {
        BasicConstraints bc = BasicConstraints.getInstance((Object)ASN1Tools.create((byte[])encoded));
        return new X509ExtensionBasicConstraints(bc.isCA());
    }

    public X509ExtensionBasicConstraints() {
        this.setCritical(true);
    }

    public X509ExtensionBasicConstraints(boolean ca) {
        this.ca = ca;
        this.setCritical(true);
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public byte[] getValue() throws IOException {
        BasicConstraints basicConstraints = new BasicConstraints(this.isCA());
        return basicConstraints.getEncoded("DER");
    }

    public boolean isCA() {
        return this.ca;
    }

    public void setCA(boolean ca) {
        this.ca = ca;
    }
}

