/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;

public class NetscapeCertificateTypeHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("NetscapeCertificateTypeHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.16.840.1.113730.1.1";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive obj = CertificateTools.getExtensionValue(object, this.getOID());
        DERBitString derType = DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)obj));
        if (derType == null) {
            return null;
        }
        int type = derType.intValue();
        StringBuilder sb = new StringBuilder();
        if ((type & 0x80) != 0) {
            sb.append("SSL client").append(StringTools.LS);
        }
        if ((type & 0x40) != 0) {
            sb.append("SSL server").append(StringTools.LS);
        }
        if ((type & 0x20) != 0) {
            sb.append("S/MIME").append(StringTools.LS);
        }
        if ((type & 0x10) != 0) {
            sb.append("Object signing").append(StringTools.LS);
        }
        if ((type & 8) != 0) {
            sb.append("Reserved").append(StringTools.LS);
        }
        if ((type & 4) != 0) {
            sb.append("SSL CA").append(StringTools.LS);
        }
        if ((type & 2) != 0) {
            sb.append("S/MIME CA").append(StringTools.LS);
        }
        if ((type & 1) != 0) {
            sb.append("Object signing CA").append(StringTools.LS);
        }
        return sb.toString();
    }
}

