/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.KeyUsage;

public class KeyUsageHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("KeyUsageHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.15";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive obj = CertificateTools.getExtensionValue(object, this.getOID());
        KeyUsage keyUsage = KeyUsage.getInstance((Object)obj);
        if (keyUsage == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (keyUsage.hasUsages(128)) {
            sb.append("Digital signature").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(64)) {
            sb.append("Non-repudiation").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(32)) {
            sb.append("Encipherment").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(16)) {
            sb.append("Data encipherment").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(8)) {
            sb.append("Agreement").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(4)) {
            sb.append("Certificate signing").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(2)) {
            sb.append("CRL signing").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(1)) {
            sb.append("Encipher only").append(StringTools.LS);
        }
        if (keyUsage.hasUsages(32768)) {
            sb.append("Decipher only").append(StringTools.LS);
        }
        return sb.toString();
    }
}

