/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension;

import de.intarsys.security.extension.IX509Extension;
import de.intarsys.security.extension.common.CommonX509Extension;
import de.intarsys.security.extension.common.X509ExtensionFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;

public class ExtensionTools {
    public static IX509Extension createExtension(Object object) {
        if (object instanceof IX509Extension) {
            return (IX509Extension)object;
        }
        if (object instanceof IArgs) {
            IArgs args = (IArgs)object;
            String oid = ArgTools.getString((IArgs)args, (String)"oid", null);
            if (oid == null) {
                throw new IllegalArgumentException("extension: oid missing");
            }
            byte[] der = ArgTools.getByteArray((IArgs)args, (String)"der", null);
            IX509Extension extension = X509ExtensionFactory.get().create(oid, der);
            if (args.isDefined("critical")) {
                ((CommonX509Extension)extension).setCritical(ArgTools.getBoolStrict((IArgs)args, (String)"critical", (boolean)false));
            }
            return extension;
        }
        throw new IllegalArgumentException("extension");
    }

    public static List<IX509Extension> getExtensions(IArgs args, String name) {
        ArrayList<IX509Extension> result = new ArrayList<IX509Extension>();
        IArgs extensions = ArgTools.getArgs((IArgs)args, (String)name, (IArgs)Args.create());
        for (int i = 0; i < extensions.size(); ++i) {
            Object oExtension = extensions.get(i);
            result.add(ExtensionTools.createExtension(oExtension));
        }
        return result;
    }

    private ExtensionTools() {
    }
}

