/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.AbstractEncoding;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.util.Arrays;

public abstract class PKCS1Encoding
extends AbstractEncoding {
    @Override
    protected byte[] basicDecode(byte[] bytes) throws IOException {
        byte b;
        int messageBegin;
        if (bytes.length < 10) {
            throw new IOException("message to small (" + bytes.length + ")");
        }
        int typIndex = 1;
        if (bytes[0] != 0) {
            --typIndex;
        }
        if (bytes[typIndex] != this.getType()) {
            throw new IOException("padding type not type " + this.getType());
        }
        int paddingBegin = messageBegin = typIndex + 1;
        while ((b = bytes[messageBegin++]) != 0) {
            this.checkPadding(b);
            if (messageBegin < bytes.length) continue;
        }
        if (messageBegin - paddingBegin < 9) {
            throw new IOException("padding too short");
        }
        byte[] tempMessage = new byte[bytes.length - messageBegin];
        System.arraycopy(bytes, messageBegin, tempMessage, 0, tempMessage.length);
        return tempMessage;
    }

    @Override
    protected byte[] basicEncode(byte[] bytes) throws IOException {
        if (bytes.length > this.getIntendedLengthBytes() - 11) {
            throw new IOException("message to long (" + bytes.length + ")");
        }
        int messageBegin = this.getIntendedLengthBytes() - bytes.length;
        byte[] encoded = new byte[this.getIntendedLengthBytes()];
        this.fillPadding(encoded, 2, messageBegin);
        encoded[0] = 0;
        encoded[1] = this.getType();
        encoded[messageBegin - 1] = 0;
        System.arraycopy(bytes, 0, encoded, messageBegin, bytes.length);
        return encoded;
    }

    @Override
    protected boolean basicMatch(byte[] bytes, byte[] encoded) throws IOException {
        byte[] unpadded = this.decode(encoded);
        if (Arrays.equals(bytes, unpadded)) {
            return true;
        }
        try {
            IDigest digest = DigestTools.decode((byte[])bytes);
            IDigest unpaddedDigest = DigestTools.decode((byte[])unpadded);
            if (Arrays.equals(digest.getBytes(), unpaddedDigest.getBytes())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected abstract void checkPadding(byte var1) throws IOException;

    protected abstract void fillPadding(byte[] var1, int var2, int var3);

    public abstract byte getType();
}

