/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.remote;

import de.intarsys.security.crl.IRemoteAccessInfo;
import de.intarsys.security.crl.IRemoteAccessor;
import de.intarsys.security.crl.remote.RemoteAccessInfoHTTP;
import de.intarsys.security.crl.remote.RemoteAccessInfoLDAP;
import de.intarsys.security.crl.remote.RemoteAccessorRegistry;
import java.io.IOException;

public class RemoteAccessTools {
    public static IRemoteAccessInfo createAccessInfo(String url) {
        if (url == null) {
            return null;
        }
        String lurl = url.toLowerCase();
        if (lurl.startsWith("http://") || lurl.startsWith("https://")) {
            return new RemoteAccessInfoHTTP(url);
        }
        if (lurl.startsWith("ldap://")) {
            return new RemoteAccessInfoLDAP(url);
        }
        return null;
    }

    public static String getUrl(IRemoteAccessInfo accessInfo) {
        if (accessInfo == null) {
            return null;
        }
        if ("HTTP".equals(accessInfo.getType())) {
            return ((RemoteAccessInfoHTTP)accessInfo).getUrl();
        }
        if ("LDAP".equals(accessInfo.getType())) {
            return ((RemoteAccessInfoLDAP)accessInfo).getUrl();
        }
        return null;
    }

    public byte[] downloadCRL(String url) throws IOException {
        IRemoteAccessInfo accessInfo = RemoteAccessTools.createAccessInfo(url);
        IRemoteAccessor accessor = RemoteAccessorRegistry.get().lookupAccessor(accessInfo);
        byte[] result = accessor.download(accessInfo);
        return result;
    }
}

