/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CRLSelector
implements IX509CRLSelector,
Cloneable {
    private static final Logger Log = LoggerFactory.getLogger(X509CRLSelector.class);
    private java.security.cert.X509CRLSelector selector = new java.security.cert.X509CRLSelector();
    private Date dateAndTime;

    public X509CRLSelector() {
    }

    private X509CRLSelector(java.security.cert.X509CRLSelector selector) {
        this.selector = selector;
    }

    public void addIssuer(X500Principal issuer) {
        this.selector.addIssuer(issuer);
    }

    public void addIssuerName(byte[] name) throws IOException {
        this.selector.addIssuerName(name);
    }

    public void addIssuerName(String name) throws IOException {
        this.selector.addIssuerName(name);
    }

    public Object clone() {
        return new X509CRLSelector((java.security.cert.X509CRLSelector)this.selector.clone());
    }

    public boolean equals(Object obj) {
        if (obj instanceof X509CRLSelector) {
            return this.selector.equals(((X509CRLSelector)obj).selector);
        }
        return false;
    }

    @Override
    public X509Certificate getCertificateChecking() {
        return this.selector.getCertificateChecking();
    }

    @Override
    public Date getDateAndTime() {
        return this.dateAndTime;
    }

    @Override
    public Collection getIssuerNames() {
        return this.selector.getIssuerNames();
    }

    @Override
    public Collection getIssuers() {
        return this.selector.getIssuers();
    }

    @Override
    public BigInteger getMaxCRL() {
        return this.selector.getMaxCRL();
    }

    @Override
    public BigInteger getMinCRL() {
        return this.selector.getMinCRL();
    }

    public int hashCode() {
        return this.selector.hashCode();
    }

    public boolean match(CRL crl) {
        return this.selector.match(crl);
    }

    @Override
    public boolean match(IX509CRL crl) {
        try {
            return this.match(crl.toJavaCRL());
        }
        catch (CRLException e) {
            return false;
        }
    }

    public void setCertificateChecking(IX509Certificate certificate) {
        if (certificate instanceof IX509PublicKeyCertificate) {
            try {
                this.setCertificateChecking(((IX509PublicKeyCertificate)certificate).toJavaCertificate());
            }
            catch (CertificateException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void setCertificateChecking(X509Certificate certificate) {
        this.selector.setCertificateChecking(certificate);
    }

    public void setDateAndTime(Date dateAndTime) {
        this.dateAndTime = dateAndTime;
    }

    public void setIssuerNames(Collection names) throws IOException {
        this.selector.setIssuerNames(names);
    }

    public void setIssuers(Collection issuers) {
        this.selector.setIssuers(issuers);
    }

    public void setMaxCRLNumber(BigInteger maxCRL) {
        this.selector.setMaxCRLNumber(maxCRL);
    }

    public void setMinCRLNumber(BigInteger minCRL) {
        this.selector.setMinCRLNumber(minCRL);
    }

    @Override
    public java.security.cert.X509CRLSelector toJavaSelector() {
        return this.selector;
    }

    public String toString() {
        return this.selector.toString();
    }
}

