/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.crl.common.CommonX509CRL;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.crl.common.X509CRLEntryObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CRL
extends CommonX509CRL {
    private static final Logger Log = LoggerFactory.getLogger(X509CRL.class);
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean indirect;
    private SoftReference<Map<EntryKey, X509CRLEntryObject>> cachedEntries;
    private Set<X500Principal> certificateIssuers;

    public X509CRL(CertificateList c) throws CRLException {
        this.c = c;
        try {
            this.sigAlgName = this.parseSigAlgName();
            this.sigAlgParams = (byte[])(c.getSignatureAlgorithm().getParameters() != null ? c.getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded("DER") : null);
            this.indirect = CrlTools.isIndirectCRL(this);
        }
        catch (Exception e) {
            throw new CRLException("CRL contents invalid: " + e);
        }
    }

    public X509CRL(de.intarsys.asn1.x509.crl.CertificateList c) throws CRLException {
        this(CertificateList.getInstance((Object)c.getValueHolder()));
    }

    @Override
    protected byte[] basicGetEncoded() throws CRLException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream dOut = ASN1OutputStream.create((OutputStream)bOut, (String)"DER");
        try {
            dOut.writeObject((ASN1Encodable)this.c);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    protected synchronized Map<EntryKey, X509CRLEntryObject> getCachedEntries() {
        Map<EntryKey, X509CRLEntryObject> entryMap = null;
        if (this.cachedEntries != null) {
            entryMap = this.cachedEntries.get();
        }
        if (entryMap == null) {
            entryMap = this.hashEntries();
            this.cachedEntries = new SoftReference<Map<EntryKey, X509CRLEntryObject>>(entryMap);
        }
        return entryMap;
    }

    @Override
    public Set<X500Principal> getCertificateIssuers() {
        if (this.certificateIssuers == null) {
            this.getCachedEntries();
        }
        return this.certificateIssuers;
    }

    @Override
    public byte[] getCertInfoList() throws CRLException {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    private Set getExtensionOIDs(boolean critical) {
        if (this.getVersion() == 2) {
            HashSet<String> set = new HashSet<String>();
            Extensions extensions = this.c.getTBSCertList().getExtensions();
            if (extensions != null) {
                Enumeration e = extensions.oids();
                while (e.hasMoreElements()) {
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                    Extension ext = extensions.getExtension(oid);
                    if (critical != ext.isCritical()) continue;
                    set.add(oid.getId());
                }
            }
            return set;
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        Extension ext;
        Extensions exts = this.c.getTBSCertList().getExtensions();
        if (exts != null && (ext = exts.getExtension(new ASN1ObjectIdentifier(oid))) != null) {
            try {
                return ext.getExtnValue().getEncoded();
            }
            catch (Exception e) {
                throw new IllegalStateException("error parsing " + e.toString());
            }
        }
        return null;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = ASN1OutputStream.create((OutputStream)bOut);
            aOut.writeObject((ASN1Encodable)this.c.getIssuer());
            return new X500Principal(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public X509CRLEntry getRevokedCertificate(IX509Certificate certificate) throws CRLException {
        X500Principal issuer = certificate.getIssuerX500Principal();
        BigInteger serial = certificate.getSerialNumber();
        return this.getRevokedCertificate(issuer, serial);
    }

    public X509CRLEntry getRevokedCertificate(X500Principal issuer, BigInteger serial) throws CRLException {
        X509CRLEntry entry = this.getCachedEntries().get(new EntryKey(issuer, serial));
        return entry;
    }

    @Override
    public Set getRevokedCertificates() throws CRLException {
        return new HashSet<X509CRLEntryObject>(this.getCachedEntries().values());
    }

    @Override
    public String getSigAlgName() {
        return this.sigAlgName;
    }

    @Override
    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            byte[] tmp = new byte[this.sigAlgParams.length];
            System.arraycopy(this.sigAlgParams, 0, tmp, 0, tmp.length);
            return tmp;
        }
        return null;
    }

    @Override
    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    @Override
    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    @Override
    public int getVersion() {
        return this.c.getVersionNumber();
    }

    protected int hashCode(X500Principal issuer, BigInteger serial) {
        String key = issuer + "/" + serial;
        return key.hashCode();
    }

    public Map<EntryKey, X509CRLEntryObject> hashEntries() {
        Log.debug("Enter: " + X509CRL.class.getName(), (Object)"hashEntries");
        TBSCertList.CRLEntry[] certs = this.c.getRevokedCertificates();
        this.certificateIssuers = new HashSet<X500Principal>();
        if (certs == null) {
            return Collections.emptyMap();
        }
        HashMap<EntryKey, X509CRLEntryObject> cachedEntries = new HashMap<EntryKey, X509CRLEntryObject>(certs.length);
        if (this.isIndirect()) {
            X500Principal previousCertificateIssuer = this.getIssuerX500Principal();
            for (int i = 0; i < certs.length; ++i) {
                X509CRLEntryObject entry = new X509CRLEntryObject(certs[i], this.isIndirect(), previousCertificateIssuer);
                previousCertificateIssuer = entry.getCertificateIssuer();
                cachedEntries.put(new EntryKey(previousCertificateIssuer, entry.getSerialNumber()), entry);
                this.certificateIssuers.add(previousCertificateIssuer);
            }
        } else {
            X500Principal issuer = this.getIssuerX500Principal();
            this.certificateIssuers.add(issuer);
            for (int i = 0; i < certs.length; ++i) {
                X509CRLEntryObject entry = new X509CRLEntryObject(certs[i], this.isIndirect(), issuer);
                cachedEntries.put(new EntryKey(issuer, entry.getSerialNumber()), entry);
            }
        }
        Log.debug("Exit: " + X509CRL.class.getName(), (Object)"hashEntries");
        return cachedEntries;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    protected boolean isIndirect() {
        return this.indirect;
    }

    @Override
    public boolean isRevoked(IX509Certificate cert) throws CRLException {
        return this.getRevokedCertificate(cert) != null;
    }

    protected String parseSigAlgName() {
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            String algName = provs[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (algName == null) continue;
            return algName;
        }
        return this.getSigAlgOID();
    }

    @Override
    public java.security.cert.X509CRL toJavaCRL() throws CRLException {
        return new X509CRLObject(this.c);
    }

    protected static class EntryKey {
        private X500Principal issuer;
        private BigInteger serial;

        public EntryKey(X500Principal issuer, BigInteger serial) {
            this.issuer = issuer;
            this.serial = serial;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryKey)) {
                return false;
            }
            EntryKey other = (EntryKey)obj;
            if (this.getIssuer() == null ? other.getIssuer() != null : !this.getIssuer().equals(other.getIssuer())) {
                return false;
            }
            return !(this.getSerial() == null ? other.getSerial() != null : !this.getSerial().equals(other.getSerial()));
        }

        public X500Principal getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public int hashCode() {
            String key = this.getIssuer() + "/" + this.getSerial();
            return key.hashCode();
        }
    }
}

