/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IRemoteAccessInfo;
import de.intarsys.security.crl.IRemoteAccessor;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.crl.remote.RemoteAccessTools;
import de.intarsys.security.crl.remote.RemoteAccessorRegistry;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IOriginProvider;
import de.intarsys.security.validation.Origin;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.stream.Stream;

public class OnlineCRLProvider
implements ICRLProvider,
IOriginProvider<IX509CRL> {
    private static final Attribute ATTR_URL = new Attribute("url");

    @Override
    public IOrigin getOrigin(IX509CRL crl) {
        String url = null;
        if (crl instanceof IAttributeSupport) {
            url = (String)((IAttributeSupport)crl).getAttribute((Object)ATTR_URL);
        }
        if (url == null) {
            return Origin.undefined();
        }
        return Origin.url(url);
    }

    @Override
    public Stream<IX509CRL> lookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        IRemoteAccessInfo accessInfo = RemoteAccessTools.createAccessInfo(url);
        if (accessInfo == null) {
            return Stream.empty();
        }
        IRemoteAccessor accessor = RemoteAccessorRegistry.get().lookupAccessor(accessInfo);
        byte[] bCrl = accessor.download(accessInfo);
        if (bCrl != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(bCrl);
            try {
                IX509CRL crl = X509CertificateFactory.get().createCRL(is);
                CrlTools.attachProvider(this).accept(crl);
                if (crl instanceof IAttributeSupport) {
                    ((IAttributeSupport)crl).setAttribute((Object)ATTR_URL, (Object)url);
                }
                return Stream.of(crl);
            }
            catch (CRLException e) {
                throw new IOException(e);
            }
        }
        return Stream.empty();
    }
}

