/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public abstract class CommonX509CRL
implements IX509CRL,
IAttributeSupport {
    private final AttributeMap attributes = new AttributeMap();
    private int hashCode = -1;
    private int length = -1;
    private ICRLProvider crlProvider;

    protected CommonX509CRL() {
    }

    protected abstract byte[] basicGetEncoded() throws CRLException;

    protected int calcHashCode(byte[] data) {
        int retval = 0;
        for (int i = 1; i < data.length; ++i) {
            retval += data[i] * i;
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IX509CRL)) {
            return false;
        }
        IX509CRL otherCrl = (IX509CRL)other;
        try {
            if (other instanceof CommonX509CRL) {
                int otherLength = ((CommonX509CRL)otherCrl).length;
                if (this.length != -1 && otherLength != -1 && this.length != otherLength) {
                    return false;
                }
                int otherHash = ((CommonX509CRL)otherCrl).hashCode;
                if (this.hashCode != -1 && otherHash != -1 && this.hashCode != otherHash) {
                    return false;
                }
            }
            byte[] thisCRL = this.getEncoded();
            byte[] otherCRL = ((IX509CRL)other).getEncoded();
            return Arrays.equals(thisCRL, otherCRL);
        }
        catch (CRLException e) {
            return false;
        }
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Set<X500Principal> getCertificateIssuers() throws CRLException {
        HashSet<X500Principal> result = new HashSet<X500Principal>();
        result.add(this.getIssuerX500Principal());
        Set revoked = this.getRevokedCertificates();
        if (revoked == null) {
            return result;
        }
        Iterator i = revoked.iterator();
        while (i.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                return Collections.emptySet();
            }
            X509CRLEntry entry = (X509CRLEntry)i.next();
            X500Principal issuer = entry.getCertificateIssuer();
            if (issuer == null) continue;
            result.add(issuer);
        }
        return result;
    }

    @Override
    public ICRLProvider getCRLProvider() {
        return this.crlProvider;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        byte[] result = this.basicGetEncoded();
        this.length = result.length;
        this.hashCode = this.calcHashCode(result);
        return result;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            try {
                this.getEncoded();
            }
            catch (CRLException cRLException) {
                // empty catch block
            }
        }
        return this.hashCode;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public Object setAttribute(Object key, Object o) {
        return this.attributes.put(key, o);
    }

    public void setCRLProvider(ICRLProvider crlProvider) {
        this.crlProvider = crlProvider;
    }
}

