/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.CommonKeyStore;
import de.intarsys.security.certificate.provider.keystore.Credential;
import de.intarsys.security.certificate.provider.keystore.ICredential;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public abstract class KeyStoreFacade
extends CommonKeyStore {
    public static String TYPE_DER = "der";
    public static String[] TYPES_X509 = new String[]{"cer", TYPE_DER, "crt"};
    public static String[] TYPES_PEM = new String[]{"pem"};
    public static String[] TYPES_PKCS12 = new String[]{"p12", "pfx", TYPE_DER};
    public static String[] TYPES_PKCS7 = new String[]{"p7b", "p7c", "cms"};
    public static String[] TYPES_JKS = new String[]{"jks", "keystore"};
    private static final String JKS = "JKS";
    private static final String X509 = "X509";
    private static final String PEM = "PEM";
    private static final String PKCS12 = "PKCS12";
    private static final String PKCS7 = "PKCS#7";
    private static boolean jks;
    private static boolean pkcs12;
    private static boolean pkcs7;
    private static boolean x509;
    private static boolean pem;
    private KeyStore keyStore;

    private static void checkKeyStoreImplementations() {
        try {
            KeyStore.getInstance(JKS);
            jks = true;
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        try {
            KeyStore.getInstance(PKCS12, "BC");
            pkcs12 = true;
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        try {
            KeyStore.getInstance(PKCS7);
            pkcs7 = true;
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        try {
            KeyStore.getInstance(X509);
            x509 = true;
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        try {
            KeyStore.getInstance(PEM);
            pem = true;
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public static KeyStoreFacade createJKS(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (KeyStoreFacade.supportsJKS()) {
            return new JKSKeyStoreFacade(locator);
        }
        throw new IOException(Format.simple((String)"No provider supports JKS keystores like {}", (Object[])new Object[]{locator}));
    }

    public static KeyStoreFacade createPEM(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (KeyStoreFacade.supportsPEM()) {
            return new PEMKeyStoreFacade(locator);
        }
        throw new IOException(Format.simple((String)"No provider supports PEM keystores like {}", (Object[])new Object[]{locator}));
    }

    public static KeyStoreFacade createPKCS12(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (KeyStoreFacade.supportsPKCS12()) {
            return new PKCS12KeyStoreFacade(locator);
        }
        throw new IOException(Format.simple((String)"No provider supports PKCS12 keystores like {}", (Object[])new Object[]{locator}));
    }

    public static KeyStoreFacade createPKCS7(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (KeyStoreFacade.supportsPKCS7()) {
            return new PKCS7KeyStoreFacade(locator);
        }
        throw new IOException(Format.simple((String)"No provider supports PKCS7 keystores like {}", (Object[])new Object[]{locator}));
    }

    protected static IOException createPolicyException(Exception e) throws IOException {
        return new IOException("Load error. Please ensure that Java(TM) Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files are installed.", e);
    }

    public static KeyStoreFacade createX509(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (KeyStoreFacade.supportsX509()) {
            return new X509KeyStoreFacade(locator);
        }
        throw new IOException(Format.simple((String)"No provider supports X.509 keystores like {}", (Object[])new Object[]{locator}));
    }

    public static KeyStore emptyJKSKeyStore() {
        if (!KeyStoreFacade.supportsJKS()) {
            return null;
        }
        KeyStore empty = null;
        try {
            empty = KeyStore.getInstance(JKS);
            empty.load(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String guessDEREncodedType(ILocator locator) {
        block6: {
            ASN1InputStream asn1In;
            block4: {
                String string;
                ASN1Encodable firstObject;
                block5: {
                    ASN1Sequence sequence;
                    asn1In = null;
                    asn1In = new ASN1InputStream(locator.getInputStream());
                    ASN1Primitive derObject = asn1In.readObject();
                    if (!(derObject instanceof ASN1Sequence) || (sequence = (ASN1Sequence)derObject).size() <= 1) break block4;
                    firstObject = sequence.getObjectAt(0);
                    if (!(firstObject instanceof ASN1Integer)) break block5;
                    String string2 = "p12";
                    StreamTools.close((Closeable)asn1In);
                    return string2;
                }
                try {
                    if (!(firstObject instanceof DERSequence)) break block4;
                    string = "cer";
                }
                catch (IOException iOException) {
                    StreamTools.close(asn1In);
                    break block6;
                }
                catch (Throwable throwable) {
                    StreamTools.close(asn1In);
                    throw throwable;
                }
                StreamTools.close((Closeable)asn1In);
                return string;
            }
            StreamTools.close((Closeable)asn1In);
        }
        return null;
    }

    public static boolean isCER(ILocator locator) {
        return KeyStoreFacade.isX509(LocatorTools.getExtension((ILocator)locator));
    }

    public static boolean isJKS(ILocator locator) {
        return KeyStoreFacade.isJKS(LocatorTools.getExtension((ILocator)locator));
    }

    protected static boolean isJKS(String type) {
        return KeyStoreFacade.hasType(type, TYPES_JKS);
    }

    public static boolean isPEM(ILocator locator) {
        return KeyStoreFacade.isPEM(LocatorTools.getExtension((ILocator)locator));
    }

    protected static boolean isPEM(String type) {
        return KeyStoreFacade.hasType(type, TYPES_PEM);
    }

    public static boolean isPKCS12(ILocator locator) {
        return KeyStoreFacade.isPKCS12(LocatorTools.getExtension((ILocator)locator));
    }

    protected static boolean isPKCS12(String type) {
        return KeyStoreFacade.hasType(type, TYPES_PKCS12);
    }

    public static boolean isPKCS7(ILocator locator) {
        return KeyStoreFacade.isPKCS7(LocatorTools.getExtension((ILocator)locator));
    }

    public static boolean isPKCS7(String type) {
        return KeyStoreFacade.hasType(type, TYPES_PKCS7);
    }

    protected static boolean isX509(String type) {
        return KeyStoreFacade.hasType(type, TYPES_X509);
    }

    private static boolean supportsJKS() {
        return jks;
    }

    private static boolean supportsPEM() {
        return pem;
    }

    private static boolean supportsPKCS12() {
        return pkcs12;
    }

    private static boolean supportsPKCS7() {
        return pkcs7;
    }

    private static boolean supportsX509() {
        return x509;
    }

    protected KeyStoreFacade(ILocator locator) {
        super(locator);
    }

    protected abstract KeyStore basicCreate() throws IOException, KeyStoreException;

    @Override
    protected void basicLoad(Secret keystorePassword) throws IOException, KeyStoreException {
        this.keyStore = this.load(this.getLocator(), keystorePassword);
    }

    @Override
    public void close() {
        super.close();
        this.keyStore = null;
    }

    public void create() throws IOException, KeyStoreException {
        if (this.keyStore != null) {
            return;
        }
        this.keyStore = this.basicCreate();
    }

    @Override
    protected ICertificateProvider createCertificateProvider() {
        return new KeyStoreCertificateProvider(this.getKeyStore());
    }

    @Override
    protected IPrivateKeyProvider createKeyProvider() {
        return new KeyStoreCertificateProvider(this.getKeyStore());
    }

    public IX509Certificate getCertificate(String alias) throws KeyStoreException {
        if (alias == null) {
            return null;
        }
        return this.getCertificateProvider().getCertificate(alias);
    }

    public Iterator<IX509Certificate> getCertificateEntities() {
        return this.getCertificateProvider().lookupCertificates(AllCertificateFilter.UNIQUE);
    }

    @Override
    public KeyStoreCertificateProvider getCertificateProvider() {
        return (KeyStoreCertificateProvider)super.getCertificateProvider();
    }

    public IX509PublicKeyCertificate getKey(String alias) throws KeyStoreException {
        if (alias == null) {
            return null;
        }
        IX509Certificate certificate = this.getCertificateProvider().getCertificate(alias);
        if (certificate instanceof IX509PublicKeyCertificate && this.getCertificateProvider().hasPrivateKey((IX509PublicKeyCertificate)certificate)) {
            return (IX509PublicKeyCertificate)certificate;
        }
        return null;
    }

    public Iterator<IX509Certificate> getKeyEntities() {
        return this.getKeyProvider().lookupCertificates(new IX509CertificateFilter(){

            @Override
            public boolean accept(IX509Certificate certificate) {
                if (certificate instanceof IX509PublicKeyCertificate) {
                    return KeyStoreFacade.this.getKeyProvider().hasPrivateKey((IX509PublicKeyCertificate)certificate);
                }
                return false;
            }

            @Override
            public boolean isX509NonRepudiation() {
                return false;
            }
        });
    }

    @Override
    public KeyStoreCertificateProvider getKeyProvider() {
        return (KeyStoreCertificateProvider)super.getKeyProvider();
    }

    public KeyStore getKeyStore() {
        if (this.keyStore == null) {
            throw new InvalidRequestException("load first");
        }
        return this.keyStore;
    }

    protected abstract KeyStore load(ILocator var1, Secret var2) throws IOException, KeyStoreException;

    static {
        KeyStoreFacade.checkKeyStoreImplementations();
    }

    private static class JKSKeyStoreFacade
    extends KeyStoreFacade {
        public JKSKeyStoreFacade(ILocator locator) {
            super(locator);
        }

        @Override
        protected KeyStore basicCreate() throws IOException, KeyStoreException {
            KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.JKS);
            try {
                keyStore.load(null, null);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            return keyStore;
        }

        @Override
        public ICredential getKeyCredential() {
            return new Credential("key", CommonKeyStore.DEFAULT_KEY_PASSWORD_LABEL, false);
        }

        @Override
        public ICredential getKeyStoreCredential() {
            return new Credential("keystore", CommonKeyStore.DEFAULT_KEYSTORE_PASSWORD_LABEL, true);
        }

        @Override
        protected KeyStore load(ILocator locator, Secret keystorePassword) throws IOException, KeyStoreException {
            InputStream stream = null;
            try {
                stream = locator.getInputStream();
                KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.JKS);
                keyStore.load(stream, null);
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw JKSKeyStoreFacade.createPolicyException(e);
            }
            finally {
                StreamTools.close((Closeable)stream);
            }
        }

        @Override
        public boolean supportsMultipleEntries() {
            return true;
        }
    }

    private static class PEMKeyStoreFacade
    extends KeyStoreFacade {
        public PEMKeyStoreFacade(ILocator locator) {
            super(locator);
        }

        @Override
        protected KeyStore basicCreate() throws IOException, KeyStoreException {
            KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.PEM);
            try {
                keyStore.load(null, null);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            return keyStore;
        }

        @Override
        public ICredential getKeyCredential() {
            return new Credential("key", CommonKeyStore.DEFAULT_KEY_PASSWORD_LABEL, false);
        }

        @Override
        protected KeyStore load(ILocator locator, Secret keystorePassword) throws IOException, KeyStoreException {
            InputStream stream = null;
            try {
                stream = locator.getInputStream();
                KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.PEM);
                keyStore.load(stream, null);
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw PEMKeyStoreFacade.createPolicyException(e);
            }
            finally {
                StreamTools.close((Closeable)stream);
            }
        }
    }

    private static class PKCS12KeyStoreFacade
    extends KeyStoreFacade {
        public PKCS12KeyStoreFacade(ILocator locator) {
            super(locator);
        }

        @Override
        protected KeyStore basicCreate() throws IOException, KeyStoreException {
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.PKCS12, "BC");
                keyStore.load(null, null);
                return keyStore;
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchProviderException e) {
                throw new KeyStoreException(e);
            }
        }

        @Override
        public ICredential getKeyStoreCredential() {
            return new Credential("keystore", CommonKeyStore.DEFAULT_KEYSTORE_PASSWORD_LABEL, false);
        }

        @Override
        protected KeyStore load(ILocator locator, Secret keystorePassword) throws IOException, KeyStoreException {
            if (keystorePassword.isEmpty()) {
                throw new KeyStoreException("password missing");
            }
            InputStream stream = null;
            try {
                stream = locator.getInputStream();
                KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.PKCS12, "BC");
                keyStore.load(stream, CryptoTools.getChars((Secret)keystorePassword));
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (GeneralSecurityException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw PKCS12KeyStoreFacade.createPolicyException(e);
            }
            finally {
                StreamTools.close((Closeable)stream);
            }
        }
    }

    private static class PKCS7KeyStoreFacade
    extends KeyStoreFacade {
        public PKCS7KeyStoreFacade(ILocator locator) {
            super(locator);
        }

        @Override
        protected KeyStore basicCreate() throws IOException, KeyStoreException {
            KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.PKCS7);
            try {
                keyStore.load(null, null);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            return keyStore;
        }

        @Override
        protected KeyStore load(ILocator locator, Secret keystorePassword) throws IOException, KeyStoreException {
            InputStream stream = null;
            try {
                stream = locator.getInputStream();
                KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.PKCS7);
                keyStore.load(stream, null);
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw PKCS7KeyStoreFacade.createPolicyException(e);
            }
            finally {
                StreamTools.close((Closeable)stream);
            }
        }
    }

    private static class X509KeyStoreFacade
    extends KeyStoreFacade {
        public X509KeyStoreFacade(ILocator locator) {
            super(locator);
        }

        @Override
        protected KeyStore basicCreate() throws IOException, KeyStoreException {
            KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.X509);
            try {
                keyStore.load(null, null);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            return keyStore;
        }

        @Override
        protected KeyStore load(ILocator locator, Secret keystorePassword) throws IOException, KeyStoreException {
            InputStream stream = null;
            try {
                stream = locator.getInputStream();
                KeyStore keyStore = KeyStore.getInstance(KeyStoreFacade.X509);
                keyStore.load(stream, null);
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                throw X509KeyStoreFacade.createPolicyException(e);
            }
            finally {
                StreamTools.close((Closeable)stream);
            }
        }
    }
}

