/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.AllCertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.concurrent.EagerInitializable;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public class EagerInitializableCertificateProvider
extends EagerInitializable<Object>
implements ICertificateProvider,
IPresentationSupport,
INotificationSupport {
    private final ICertificateProvider delegate;
    private final boolean completeSearch;

    public EagerInitializableCertificateProvider(ICertificateProvider delegate) {
        this(delegate, true);
    }

    public EagerInitializableCertificateProvider(ICertificateProvider delegate, boolean completeSearch) {
        this.delegate = delegate;
        this.completeSearch = completeSearch;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.delegate instanceof INotificationSupport) {
            ((INotificationSupport)this.delegate).addNotificationListener(type, listener);
        }
    }

    @Override
    public boolean containsCertificate(IX509Certificate certificate) {
        return this.getDelegate().containsCertificate(certificate);
    }

    public ICertificateProvider getDelegate() {
        this.waitInitialized();
        return this.delegate;
    }

    public String getDescription() {
        if (this.delegate instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.delegate).getDescription();
        }
        return null;
    }

    public String getIconName() {
        if (this.delegate instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.delegate).getIconName();
        }
        return null;
    }

    public String getLabel() {
        if (this.delegate instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.delegate).getLabel();
        }
        return null;
    }

    public String getTip() {
        if (this.delegate instanceof IPresentationSupport) {
            return ((IPresentationSupport)this.delegate).getTip();
        }
        return null;
    }

    protected Object initializeValue() {
        if (this.isCompleteSearch()) {
            Iterator<IX509Certificate> i = this.delegate.lookupCertificates(AllCertificateFilter.UNIQUE);
            while (i.hasNext()) {
                i.next();
            }
        } else {
            X509CertificateSelector filter = new X509CertificateSelector();
            filter.setSubjectMatchStrict(true);
            filter.setSubject(new X500Principal("CN=Init"));
            Iterator<IX509Certificate> result = this.delegate.lookupCertificates(filter);
            if (result.hasNext()) {
                result.next();
            }
        }
        return null;
    }

    public boolean isCompleteSearch() {
        return this.completeSearch;
    }

    @Override
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        return this.getDelegate().lookupCertificates(filter);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.delegate instanceof INotificationSupport) {
            ((INotificationSupport)this.delegate).removeNotificationListener(type, listener);
        }
    }
}

