/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;

public class X509CertificateResolver {
    private final IX509Certificate certificate;

    public X509CertificateResolver(IX509Certificate certificate) {
        this.certificate = certificate;
    }

    public String getAlias() {
        if (this.certificate instanceof IX509PublicKeyCertificate) {
            return ((IX509PublicKeyCertificate)this.certificate).getAlias();
        }
        return null;
    }

    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    public String getIssuer() {
        return this.certificate.getIssuerX500Principal().toString();
    }

    public String getSerialNumber() {
        return CertificateTools.getSerialNumber(this.certificate);
    }

    public String getSubject() {
        return this.certificate.getSubjectX500Principal().toString();
    }

    public String getUsage() {
        if (this.certificate instanceof IX509PublicKeyCertificate) {
            return ((IX509PublicKeyCertificate)this.certificate).getCertificateUsage().getName();
        }
        return null;
    }
}

