/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificateOwner;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorSerializer;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;

public class CertificateFilterTools {
    public static IX509CertificateFilter createCertificateFilter(Object value) throws ObjectCreationException {
        if (value instanceof IX509CertificateFilter) {
            return (IX509CertificateFilter)value;
        }
        if (value instanceof IX509PublicKeyCertificateOwner) {
            value = ((IX509PublicKeyCertificateOwner)value).getX509PublicKeyCertificate();
        }
        if (value instanceof IArgs) {
            try {
                value = LocatorTools.createLocator((Object)value, (ILocatorFactory)LocatorFactory.get(), null);
            }
            catch (IOException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (value instanceof byte[]) {
            try {
                value = X509CertificateFactory.get().createCertificate((byte[])value);
            }
            catch (CertificateException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (value instanceof ILocator) {
            try {
                value = X509CertificateFactory.get().createCertificate(((ILocator)value).getInputStream());
            }
            catch (CertificateException e) {
                throw new ObjectCreationException((Throwable)e);
            }
            catch (IOException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        if (value instanceof IX509PublicKeyCertificate) {
            IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)value;
            return X509CertificateSelector.createFrom(certificate);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String tmpString = ((String)value).trim();
            if (StringTools.isEmpty((String)tmpString)) {
                return null;
            }
            try {
                if (tmpString.startsWith("<")) {
                    IElement element = ElementFactory.get().parse((Reader)new StringReader(tmpString)).getRootElement();
                    return (IX509CertificateFilter)ElementTools.createObject((IElement)element, IX509CertificateFilter.class, null, (IArgs)Args.create());
                }
                X509CertificateSelectorSerializer serializer = new X509CertificateSelectorSerializer();
                return serializer.deserialize(tmpString);
            }
            catch (Exception e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        throw new ObjectCreationException("can't create certificate filter from " + value);
    }

    public static IX509CertificateFilter getCertificateFilter(IArgs args, String name) throws ObjectCreationException {
        Object identifier = args.get(name);
        return CertificateFilterTools.createCertificateFilter(identifier);
    }
}

