/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.AttributeAny;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.CertificateUsage;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.attribute.IX509AttributeFactory;
import de.intarsys.security.certificate.attribute.UnknownAttribute;
import de.intarsys.security.certificate.attribute.X509AttributeFactory;
import de.intarsys.security.certificate.common.CommonX509Certificate;
import de.intarsys.security.standard.validation.QCTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.util.encoders.Hex;

public abstract class CommonX509PublicKeyCertificate
extends CommonX509Certificate
implements IX509PublicKeyCertificate {
    private String alias;
    private Map<String, IX509Attribute> x509Attributes;

    protected CommonX509PublicKeyCertificate() {
    }

    protected Map<String, IX509Attribute> createAttributeMap() {
        IX509AttributeFactory factory = X509AttributeFactory.get();
        HashMap<String, IX509Attribute> result = new HashMap<String, IX509Attribute>();
        for (String oid : this.getExtensionOIDs()) {
            ASN1Primitive value;
            try {
                value = CertificateTools.getExtensionValue(this, oid);
            }
            catch (IOException e) {
                continue;
            }
            IX509Attribute attr = factory.create((Attribute)AttributeAny.create((String)oid, (ASN1Encodable)value));
            if (attr == null || attr instanceof UnknownAttribute) continue;
            result.put(attr.getType(), attr);
        }
        return result;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public CertificateUsage getCertificateUsage() {
        boolean[] keyUsage = this.getKeyUsage();
        if (keyUsage == null || keyUsage.length < 9) {
            return CertificateUsage.UNKNOWN;
        }
        String[] qualifiers = null;
        try {
            if (QCTools.isQualificationPostulated(this)) {
                qualifiers = new String[]{"qualifiedCertificate"};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CertificateUsage(keyUsage, qualifiers);
    }

    @Override
    public int getKeyBitSize() {
        return PpkTools.getKeyBitSize(this.getPublicKey());
    }

    @Override
    public String getType() {
        return "PublicKeyCertificate";
    }

    @Override
    public IX509Attribute getX509Attribute(String oid) {
        return this.getX509AttributeMap().get(oid);
    }

    protected Map<String, IX509Attribute> getX509AttributeMap() {
        if (this.x509Attributes == null) {
            this.x509Attributes = this.createAttributeMap();
        }
        return this.x509Attributes;
    }

    @Override
    public IX509Attribute[] getX509Attributes() {
        Collection<IX509Attribute> attrs = this.getX509AttributeMap().values();
        return attrs.toArray(new IX509Attribute[attrs.size()]);
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate toJavaCertificate() throws CertificateException {
        X509Certificate x509Certificate;
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(this.getEncoded());
            x509Certificate = (X509Certificate)cf.generateCertificate(is);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close((Closeable)is);
        return x509Certificate;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = StringTools.LS;
        buf.append("    [0]         Version: ").append(this.getVersion()).append(nl);
        buf.append("           SerialNumber: ").append(this.getSerialNumber()).append(nl);
        buf.append("               IssuerDN: ").append(this.getIssuerX500Principal()).append(nl);
        buf.append("             Start Date: ").append(this.getNotBefore()).append(nl);
        buf.append("             Final Date: ").append(this.getNotAfter()).append(nl);
        buf.append("              SubjectDN: ").append(this.getSubjectX500Principal()).append(nl);
        buf.append("             Public Key: ").append(this.getPublicKey()).append(nl);
        buf.append("    Signature Algorithm: ").append(this.getSigAlgName()).append(nl);
        buf.append("                  Usage: ").append(this.getCertificateUsage()).append(nl);
        byte[] sig = this.getSignature();
        buf.append("              Signature: ").append(new String(Hex.encode((byte[])sig, (int)0, (int)20))).append(nl);
        for (int i = 20; i < sig.length; i += 20) {
            if (i < sig.length - 20) {
                buf.append("                         ").append(new String(Hex.encode((byte[])sig, (int)i, (int)20))).append(nl);
                continue;
            }
            buf.append("                         ").append(new String(Hex.encode((byte[])sig, (int)i, (int)(sig.length - i)))).append(nl);
        }
        Set<String> extensions = this.getCriticalExtensionOIDs();
        if (extensions != null && !extensions.isEmpty()) {
            buf.append("    Critical extensions: ");
            for (String oid : extensions) {
                buf.append(oid);
                buf.append(nl);
                buf.append("                         ");
            }
            buf.append(nl);
        }
        if ((extensions = this.getNonCriticalExtensionOIDs()) != null && !extensions.isEmpty()) {
            buf.append("Non-critical extensions: ");
            for (String oid : extensions) {
                buf.append(oid);
                buf.append(nl);
                buf.append("                         ");
            }
        }
        return buf.toString();
    }
}

