/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.common.CanonicalFromIX509CertificateConverter;
import de.intarsys.security.certificate.common.IPCObjectFromIX509CertificateConverter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.extension.DefaultX509Extension;
import de.intarsys.security.extension.IX509Extension;
import de.intarsys.tools.attribute.AttributeMap;
import java.io.Serializable;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CommonX509Certificate
implements IX509Certificate,
Serializable {
    private final AttributeMap attributes = new AttributeMap();
    private ICertificateProvider certificateProvider;
    private IX509Extension[] x509Extensions;

    protected CommonX509Certificate() {
    }

    protected IX509Extension[] basicGetX509Extensions() {
        if (this.x509Extensions == null) {
            this.x509Extensions = this.createX509Extensions();
        }
        return this.x509Extensions;
    }

    protected IX509Extension[] createX509Extensions() {
        ArrayList<IX509Extension> result = new ArrayList<IX509Extension>();
        this.createX509Extensions(result, this.getCriticalExtensionOIDs(), true);
        this.createX509Extensions(result, this.getNonCriticalExtensionOIDs(), false);
        return result.toArray(new IX509Extension[result.size()]);
    }

    protected void createX509Extensions(List<IX509Extension> result, Set oids, boolean critical) {
        if (oids == null) {
            return;
        }
        for (String oid : oids) {
            byte[] value = this.getExtensionValue(oid);
            DefaultX509Extension extension = new DefaultX509Extension(oid, value, critical);
            result.add(extension);
        }
    }

    public boolean equals(Object o) {
        return CertificateTools.equals(this, o);
    }

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    public Set getExtensionOIDs() {
        HashSet<String> result = new HashSet<String>();
        if (this.getCriticalExtensionOIDs() != null) {
            result.addAll(this.getCriticalExtensionOIDs());
        }
        if (this.getNonCriticalExtensionOIDs() != null) {
            result.addAll(this.getNonCriticalExtensionOIDs());
        }
        return result;
    }

    @Override
    public String getSigAlgName() {
        Provider prov = Security.getProvider("BC");
        String algName = prov.getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
        if (algName != null) {
            return algName;
        }
        Provider[] provs = Security.getProviders();
        for (int i = 0; i != provs.length; ++i) {
            algName = provs[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (algName == null) continue;
            return algName;
        }
        if ("1.2.840.113549.1.1.10".equals(this.getSigAlgOID())) {
            return "RSASSA-PSS";
        }
        return this.getSigAlgOID();
    }

    @Override
    public IX509Extension getX509Extension(String oid) {
        IX509Extension[] temp;
        for (IX509Extension extension : temp = this.basicGetX509Extensions()) {
            if (!extension.getOid().equals(oid)) continue;
            return extension;
        }
        return null;
    }

    @Override
    public IX509Extension[] getX509Extensions() {
        return this.basicGetX509Extensions();
    }

    public int hashCode() {
        return CertificateTools.hashCode(this);
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.attributes.put(key, o);
    }

    public void setCertificateProvider(ICertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    static {
        new CanonicalFromIX509CertificateConverter();
        new IPCObjectFromIX509CertificateConverter();
    }
}

