/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.AttributeAny;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.attribute.AdditionalInformationAttribute;
import de.intarsys.security.certificate.attribute.AdmissionAttribute;
import de.intarsys.security.certificate.attribute.CommonNameAttribute;
import de.intarsys.security.certificate.attribute.CountryOfCitizenshipAttribute;
import de.intarsys.security.certificate.attribute.CountryOfResidenceAttribute;
import de.intarsys.security.certificate.attribute.DateOfBirthAttribute;
import de.intarsys.security.certificate.attribute.GenderAttribute;
import de.intarsys.security.certificate.attribute.GivenNameAttribute;
import de.intarsys.security.certificate.attribute.ISISMTTDeclarationOfMajority;
import de.intarsys.security.certificate.attribute.ISISMTTLiabilityLimitationFlagAttribute;
import de.intarsys.security.certificate.attribute.ISISMTTMonetaryLimit;
import de.intarsys.security.certificate.attribute.ISISMTTQcEuLimitValue;
import de.intarsys.security.certificate.attribute.ISISMTTRestriction;
import de.intarsys.security.certificate.attribute.IX509AttributeFactory;
import de.intarsys.security.certificate.attribute.NameAtBirthAttribute;
import de.intarsys.security.certificate.attribute.PlaceOfBirthAttribute;
import de.intarsys.security.certificate.attribute.PostalAddressAttribute;
import de.intarsys.security.certificate.attribute.ProcurationAttribute;
import de.intarsys.security.certificate.attribute.SubjectDirectoryAttributes;
import de.intarsys.security.certificate.attribute.SurnameAttribute;
import de.intarsys.security.certificate.attribute.TitleAttribute;
import de.intarsys.security.certificate.attribute.UnknownAttribute;
import de.intarsys.tools.component.SingletonClass;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

@SingletonClass
public class X509AttributeFactory
implements IX509AttributeFactory {
    private static final String OID_FIELD_NAME = "OID";
    private static X509AttributeFactory Instance;
    private Map oidMap = new HashMap();

    public static synchronized IX509AttributeFactory get() {
        if (Instance == null) {
            Instance = new X509AttributeFactory();
        }
        return Instance;
    }

    protected X509AttributeFactory() {
        this.addOID(AdditionalInformationAttribute.class);
        this.addOID(ISISMTTRestriction.class);
        this.addOID(ProcurationAttribute.class);
        this.addOID(SubjectDirectoryAttributes.class);
        this.addOID(AdmissionAttribute.class);
        this.addOID(CommonNameAttribute.class);
        this.addOID(CountryOfCitizenshipAttribute.class);
        this.addOID(CountryOfResidenceAttribute.class);
        this.addOID(DateOfBirthAttribute.class);
        this.addOID(GenderAttribute.class);
        this.addOID(GivenNameAttribute.class);
        this.addOID(ISISMTTDeclarationOfMajority.class);
        this.addOID(ISISMTTMonetaryLimit.class);
        this.addOID(ISISMTTQcEuLimitValue.class);
        this.addOID(ISISMTTLiabilityLimitationFlagAttribute.class);
        this.addOID(NameAtBirthAttribute.class);
        this.addOID(PlaceOfBirthAttribute.class);
        this.addOID(PostalAddressAttribute.class);
        this.addOID(SurnameAttribute.class);
        this.addOID(TitleAttribute.class);
        this.addOID(UnknownAttribute.class);
    }

    private void addOID(Class pClass) {
        String oid;
        try {
            Field oidField = pClass.getField(OID_FIELD_NAME);
            oid = (String)oidField.get(new String());
        }
        catch (SecurityException e) {
            return;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("public static field OID must be present", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("public static field OID must be present", e);
        }
        this.oidMap.put(oid, pClass);
    }

    @Override
    public IX509Attribute create(Attribute attribute) {
        String oid = attribute.getAttrType();
        Class<UnknownAttribute> attributeClass = (Class<UnknownAttribute>)this.oidMap.get(oid);
        if (attributeClass == null) {
            attributeClass = UnknownAttribute.class;
        }
        try {
            Constructor constructor = attributeClass.getConstructor(Attribute.class);
            Object instance = constructor.newInstance(attribute);
            return (IX509Attribute)instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("constructor accepting a single 'Attribute' must be present", e);
        }
    }

    public IX509Attribute create(byte[] derEncodedAttribute) throws IOException {
        Attribute attribute = (Attribute)ASN1BasedTools.create((ASN1Based.Factory)AttributeAny.FACTORY, (byte[])derEncodedAttribute);
        return this.create(attribute);
    }
}

