/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.x509.attr.AttributeCertificateIssuer;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509CertificateReference;
import java.io.IOException;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DERBitString;

public class X509AttributeCertificateIssuer
implements IX509CertificateReference {
    private AttributeCertificateIssuer impl;
    private X500Principal subject;
    private X500Principal issuer;
    private BigInteger serial;
    private boolean[] issuerUniqueId;
    private int hashCode = -1;

    public X509AttributeCertificateIssuer(AttributeCertificateIssuer impl) throws IOException {
        this.impl = impl;
        if (impl.getIssuerName() != null) {
            this.subject = CertificateTools.parsePrincipal(impl.getIssuerName());
        } else if (impl.getBaseCertificateId() != null) {
            IssuerSerial issuerSerial = impl.getBaseCertificateId();
            GeneralName generalName = issuerSerial.getIssuer().getName(0);
            this.issuer = CertificateTools.parsePrincipal(generalName);
            this.serial = issuerSerial.getSerial().getValue();
            DERBitString id = issuerSerial.getIssuerUniqueId();
            this.issuerUniqueId = CertificateTools.parseUniqueId(id);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IX509CertificateReference)) {
            return false;
        }
        IX509CertificateReference other = (IX509CertificateReference)obj;
        if (this.getSubjectX500Principal() != null) {
            if (other.getSubjectX500Principal() == null) {
                return false;
            }
            return this.getSubjectX500Principal().equals(other.getSubjectX500Principal());
        }
        return this.getIssuerX500Principal().equals(other.getIssuerX500Principal()) && this.getSerialNumber().equals(other.getSerialNumber());
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueId;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.issuer;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serial;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.subject;
    }

    public int hashCode() {
        if (this.hashCode != -1) {
            return this.hashCode;
        }
        if (this.getSubjectX500Principal() == null) {
            String key = this.issuer.hashCode() + "/" + this.serial.hashCode();
            this.hashCode = key.hashCode();
        } else {
            this.hashCode = this.getSubjectX500Principal().hashCode();
        }
        return this.hashCode;
    }
}

