/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.security.certificate.attribute.AbstractSingleValueAttribute;
import de.intarsys.tools.date.DateTools;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERPrintableString;

public class ISISMTTDeclarationOfMajority
extends AbstractSingleValueAttribute {
    public static final String OID = "1.3.36.8.3.5";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    public ISISMTTDeclarationOfMajority(Attribute attribute) {
        super(attribute);
    }

    @Override
    public String getLabel() {
        return Msg.getString("ISISMTTDeclarationOfMajority.Label", new Object[0]);
    }

    @Override
    public String getStringValue() {
        ASN1TaggedHolder taggedObject = (ASN1TaggedHolder)this.getAttribute().getAttrValue(0);
        taggedObject.setExplicit(false);
        ASN1Primitive value = taggedObject.getChild().toASN1Primitive();
        switch (taggedObject.getTagNo()) {
            case 0: {
                byte[] bytes;
                String age = null;
                if (value instanceof ASN1Integer) {
                    age = value.toASN1Primitive().toString();
                } else if (value instanceof ASN1OctetString && (bytes = ((ASN1OctetString)value).getOctets()) != null && bytes.length > 0) {
                    age = String.valueOf(bytes[0] & 0xFF);
                }
                if (age == null) {
                    age = "???";
                }
                return Msg.getString("ISISMTTDeclarationOfMajority.ValueNotYoungerThan", new Object[]{age});
            }
            case 1: {
                boolean fullAge;
                ASN1Sequence seq = (ASN1Sequence)value;
                String country = null;
                if (seq.size() == 1) {
                    fullAge = true;
                    country = ((DERPrintableString)seq.getObjectAt(0)).getString();
                } else {
                    fullAge = ((ASN1Boolean)seq.getObjectAt(0)).isTrue();
                    country = ((DERPrintableString)seq.getObjectAt(1)).getString();
                }
                if (fullAge) {
                    return Msg.getString("ISISMTTDeclarationOfMajority.ValueFullAgeAt", new Object[]{country});
                }
                return Msg.getString("ISISMTTDeclarationOfMajority.ValueMinorAgeAt", new Object[]{country});
            }
        }
        try {
            Date dateOfBirth = ((ASN1GeneralizedTime)value).getDate();
            String date = FORMATTER.format(DateTools.toLocalDate((Date)dateOfBirth));
            return Msg.getString("ISISMTTDeclarationOfMajority.ValueDateOfBirth", new Object[]{date});
        }
        catch (ParseException e) {
            return "unknown";
        }
    }
}

