/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate;

import de.intarsys.security.certificate.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CertificateUsage {
    public static final String KEYUSAGE_CRL_SIGN = "cRLSign";
    public static final String KEYUSAGE_DATA_ENCIPHERMENT = "dataEncipherment";
    public static final String KEYUSAGE_DECIPHER_ONLY = "decipherOnly";
    public static final String KEYUSAGE_DIGITAL_SIGNATURE = "digitalSignature";
    public static final String KEYUSAGE_ENCIPHER_ONLY = "encipherOnly";
    public static final String KEYUSAGE_NON_REPUDIATION = "nonRepudiation";
    public static final String KEYUSAGE_KEY_AGREEMENT = "keyAgreement";
    public static final String KEYUSAGE_KEY_CERT_SIGN = "keyCertSign";
    public static final String KEYUSAGE_KEY_ENCIPHERMENT = "keyEncipherment";
    public static final Map<String, Integer> KEYUSAGE_INDICES = new HashMap<String, Integer>();
    public static final CertificateUsage AUTHENTICATION_AND_ENCRYPTION;
    public static final CertificateUsage CA;
    public static final CertificateUsage ENCRYPTION;
    private static final IMessageBundle Msg;
    public static final String NAME_AUTHENTICATION_AND_ENCRYPTION = "authentication_and_encryption";
    public static final String NAME_CA = "ca";
    public static final String NAME_ENCRYPTION = "encryption";
    public static final String NAME_QUALIFIED_SIGNATURE = "qualified_signature";
    public static final String NAME_SIGNATURE = "signature";
    public static final String NAME_SIGNATURE_QUALIFIED = "signature_qualified";
    public static final String NAME_SIGNATURE_WITH_NONREPUDIATION = "signature_with_nonrepudiation";
    public static final String NAME_SIGNATURE_WITHOUT_NONREPUDIATION = "signature_without_nonrepudiation";
    public static final String NAME_UNKNOWN = "unknown";
    public static final String QUALIFIER_QC = "qualifiedCertificate";
    public static final CertificateUsage SIGNATURE_WITH_NONREPUDIATION;
    public static final CertificateUsage SIGNATURE_WITHOUT_NONREPUDIATION;
    public static final CertificateUsage SIGNATURE_QUALIFIED;
    public static final CertificateUsage UNKNOWN;
    private final boolean cRLSign;
    private final boolean dataEncipherment;
    private final boolean decipherOnly;
    private final boolean digitalSignature;
    private final boolean encipherOnly;
    private final boolean keyAgreement;
    private final boolean keyCertSign;
    private final boolean keyEncipherment;
    private final boolean nonRepudiation;
    private final String[] qualifiers;

    public static CertificateUsage createFromName(String name) {
        if (NAME_AUTHENTICATION_AND_ENCRYPTION.equals(name)) {
            return AUTHENTICATION_AND_ENCRYPTION;
        }
        if (NAME_CA.equals(name)) {
            return CA;
        }
        if (NAME_ENCRYPTION.equals(name)) {
            return ENCRYPTION;
        }
        if (NAME_QUALIFIED_SIGNATURE.equals(name)) {
            return SIGNATURE_QUALIFIED;
        }
        if (NAME_SIGNATURE_QUALIFIED.equals(name)) {
            return SIGNATURE_QUALIFIED;
        }
        if (NAME_SIGNATURE.equals(name)) {
            return SIGNATURE_WITHOUT_NONREPUDIATION;
        }
        if (NAME_SIGNATURE_WITH_NONREPUDIATION.equals(name)) {
            return SIGNATURE_WITH_NONREPUDIATION;
        }
        if (NAME_SIGNATURE_WITHOUT_NONREPUDIATION.equals(name)) {
            return SIGNATURE_WITHOUT_NONREPUDIATION;
        }
        return UNKNOWN;
    }

    protected static String[] mergeQualifiers(String[] qualifiers1, String[] qualifiers2) {
        if (qualifiers1 == null) {
            if (qualifiers2 == null) {
                return null;
            }
            return qualifiers2;
        }
        if (qualifiers2 == null) {
            return qualifiers1;
        }
        String[] result = new String[qualifiers1.length + qualifiers2.length];
        System.arraycopy(qualifiers1, 0, result, 0, qualifiers1.length);
        System.arraycopy(qualifiers2, 0, result, qualifiers1.length, qualifiers2.length);
        return result;
    }

    public CertificateUsage(boolean digitalSignature, boolean nonRepudiation, boolean keyEncipherment, boolean dataEncipherment, String ... qualifiers) {
        this.digitalSignature = digitalSignature;
        this.nonRepudiation = nonRepudiation;
        this.keyEncipherment = keyEncipherment;
        this.dataEncipherment = dataEncipherment;
        this.qualifiers = qualifiers;
        this.keyAgreement = false;
        this.keyCertSign = false;
        this.cRLSign = false;
        this.encipherOnly = false;
        this.decipherOnly = false;
    }

    public CertificateUsage(boolean[] x509KeyUsage, String ... qualifiers) {
        assert (x509KeyUsage != null);
        assert (x509KeyUsage.length >= 9);
        this.digitalSignature = x509KeyUsage[0];
        this.nonRepudiation = x509KeyUsage[1];
        this.keyEncipherment = x509KeyUsage[2];
        this.dataEncipherment = x509KeyUsage[3];
        this.keyAgreement = x509KeyUsage[4];
        this.keyCertSign = x509KeyUsage[5];
        this.cRLSign = x509KeyUsage[6];
        this.encipherOnly = x509KeyUsage[7];
        this.decipherOnly = x509KeyUsage[8];
        this.qualifiers = qualifiers;
    }

    public CertificateUsage(CertificateUsage template, String ... qualifiers) {
        this.digitalSignature = template.isX509DigitalSignature();
        this.nonRepudiation = template.isX509NonRepudiation();
        this.keyEncipherment = template.isX509KeyEncipherment();
        this.dataEncipherment = template.isX509DataEncipherment();
        this.keyAgreement = template.isX509KeyAgreement();
        this.keyCertSign = template.isX509KeyCertSign();
        this.cRLSign = template.isX509CRLSign();
        this.encipherOnly = template.isX509EncipherOnly();
        this.decipherOnly = template.isX509DecipherOnly();
        this.qualifiers = CertificateUsage.mergeQualifiers(template.getQualifiers(), qualifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CertificateUsage) {
            CertificateUsage other = (CertificateUsage)obj;
            return this.digitalSignature == other.digitalSignature && this.nonRepudiation == other.nonRepudiation && this.keyEncipherment == other.keyEncipherment && this.dataEncipherment == other.dataEncipherment && this.keyAgreement == other.keyAgreement && this.keyCertSign == other.keyCertSign && this.cRLSign == other.cRLSign && this.encipherOnly == other.encipherOnly && this.decipherOnly == other.decipherOnly;
        }
        return false;
    }

    public String getLabel() {
        return Msg.getString("CertificateUsage." + this.getName(), new Object[0]);
    }

    public String getName() {
        if (this.nonRepudiation) {
            if (this.hasQualifier(QUALIFIER_QC)) {
                return NAME_QUALIFIED_SIGNATURE;
            }
            return NAME_SIGNATURE_WITH_NONREPUDIATION;
        }
        if (this.dataEncipherment && this.keyEncipherment) {
            if (this.digitalSignature) {
                return NAME_AUTHENTICATION_AND_ENCRYPTION;
            }
            return NAME_ENCRYPTION;
        }
        if (this.digitalSignature) {
            if (this.hasQualifier(QUALIFIER_QC)) {
                return NAME_QUALIFIED_SIGNATURE;
            }
            return NAME_SIGNATURE_WITHOUT_NONREPUDIATION;
        }
        if (this.cRLSign || this.keyCertSign) {
            return NAME_CA;
        }
        return NAME_UNKNOWN;
    }

    public String[] getQualifiers() {
        if (this.qualifiers == null) {
            return null;
        }
        return Arrays.copyOf(this.qualifiers, this.qualifiers.length);
    }

    public boolean[] getX509KeyUsage() {
        boolean[] x509KeyUsage = new boolean[]{this.digitalSignature, this.nonRepudiation, this.keyEncipherment, this.dataEncipherment, this.keyAgreement, this.keyCertSign, this.cRLSign, this.encipherOnly, this.decipherOnly};
        return x509KeyUsage;
    }

    public int hashCode() {
        return Objects.hash(this.digitalSignature, this.nonRepudiation, this.keyEncipherment, this.dataEncipherment, this.keyAgreement, this.keyCertSign, this.cRLSign, this.encipherOnly, this.decipherOnly);
    }

    public boolean hasQualifier(String qualifier) {
        if (this.qualifiers == null) {
            return false;
        }
        for (String q : this.qualifiers) {
            if (!q.equals(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isAuthentication() {
        return this.digitalSignature && !this.nonRepudiation;
    }

    public boolean isEncryption() {
        return this.dataEncipherment || this.keyEncipherment;
    }

    public boolean isSignature() {
        return this.digitalSignature || this.nonRepudiation;
    }

    public boolean isSignatureWithNonRepudiation() {
        return this.nonRepudiation;
    }

    public boolean isSignatureWithoutNonRepudiation() {
        return this.digitalSignature && !this.nonRepudiation;
    }

    public boolean isX509CRLSign() {
        return this.cRLSign;
    }

    public boolean isX509DataEncipherment() {
        return this.dataEncipherment;
    }

    public boolean isX509DecipherOnly() {
        return this.decipherOnly;
    }

    public boolean isX509DigitalSignature() {
        return this.digitalSignature;
    }

    public boolean isX509EncipherOnly() {
        return this.encipherOnly;
    }

    public boolean isX509KeyAgreement() {
        return this.keyAgreement;
    }

    public boolean isX509KeyCertSign() {
        return this.keyCertSign;
    }

    public boolean isX509KeyEncipherment() {
        return this.keyEncipherment;
    }

    public boolean isX509NonRepudiation() {
        return this.nonRepudiation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.cRLSign) {
            sb.append("cRLSign ");
        }
        if (this.dataEncipherment) {
            sb.append("dataEncipherment ");
        }
        if (this.decipherOnly) {
            sb.append("decipherOnly ");
        }
        if (this.digitalSignature) {
            sb.append("digitalSignature ");
        }
        if (this.encipherOnly) {
            sb.append("encipherOnly ");
        }
        if (this.keyAgreement) {
            sb.append("keyAgreement ");
        }
        if (this.keyCertSign) {
            sb.append("keyCertSign ");
        }
        if (this.keyEncipherment) {
            sb.append("keyEncipherment ");
        }
        if (this.nonRepudiation) {
            sb.append("nonRepudiation ");
        }
        return sb.toString();
    }

    static {
        KEYUSAGE_INDICES.put(KEYUSAGE_DIGITAL_SIGNATURE, 0);
        KEYUSAGE_INDICES.put(KEYUSAGE_NON_REPUDIATION, 1);
        KEYUSAGE_INDICES.put(KEYUSAGE_KEY_ENCIPHERMENT, 2);
        KEYUSAGE_INDICES.put(KEYUSAGE_DATA_ENCIPHERMENT, 3);
        KEYUSAGE_INDICES.put(KEYUSAGE_KEY_AGREEMENT, 4);
        KEYUSAGE_INDICES.put(KEYUSAGE_KEY_CERT_SIGN, 5);
        KEYUSAGE_INDICES.put(KEYUSAGE_CRL_SIGN, 6);
        KEYUSAGE_INDICES.put(KEYUSAGE_ENCIPHER_ONLY, 7);
        KEYUSAGE_INDICES.put(KEYUSAGE_DECIPHER_ONLY, 8);
        KEYUSAGE_INDICES.put("0", 0);
        KEYUSAGE_INDICES.put("1", 1);
        KEYUSAGE_INDICES.put("2", 2);
        KEYUSAGE_INDICES.put("3", 3);
        KEYUSAGE_INDICES.put("4", 4);
        KEYUSAGE_INDICES.put("5", 5);
        KEYUSAGE_INDICES.put("6", 6);
        KEYUSAGE_INDICES.put("7", 7);
        KEYUSAGE_INDICES.put("8", 8);
        AUTHENTICATION_AND_ENCRYPTION = new CertificateUsage(true, false, true, true, new String[0]);
        CA = new CertificateUsage(new boolean[]{false, false, false, false, false, true, true, false, false}, new String[0]);
        ENCRYPTION = new CertificateUsage(false, false, true, true, new String[0]);
        Msg = PACKAGE.Messages;
        SIGNATURE_WITH_NONREPUDIATION = new CertificateUsage(true, true, false, false, new String[0]);
        SIGNATURE_WITHOUT_NONREPUDIATION = new CertificateUsage(true, false, false, false, new String[0]);
        SIGNATURE_QUALIFIED = new CertificateUsage(true, true, false, false, QUALIFIER_QC);
        UNKNOWN = new CertificateUsage(new boolean[]{false, false, false, false, false, false, false, false, false}, new String[0]);
    }
}

