/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.ExtensionProfileSet;
import de.intarsys.security.app.validation.commonpki.qes.ExtensionProfileValidator;
import de.intarsys.security.app.validation.commonpki.qes.IExtensionProfileSet;
import de.intarsys.security.app.validation.commonpki.qes.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.ITrustService;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.ServiceTypes;
import de.intarsys.security.certificate.TrustServiceTools;
import de.intarsys.security.certificate.filter.SimpleServiceTypeSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.PreselectCertificateProvider;
import de.intarsys.security.certificate.provider.standard.StandardCertificateProviderTools;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.QCInfo;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.VSCertificatePath;
import de.intarsys.security.standard.validation.VSQualificationCertificate;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IQCInfo;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.QCType;
import de.intarsys.tools.collection.ReverseListIterator;
import de.intarsys.tools.currency.Iso4217;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public abstract class QESCertificateReviewer
implements IReviewer<IX509Certificate, IVSCertificate> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final String QC_STATEMENTS = "1.3.6.1.5.5.7.1.3";
    private static final String KEY_USAGE = "2.5.29.15";
    private static final String BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String EXTENDED_KEY_USAGE = "2.5.29.37";
    private final int severity;

    public QESCertificateReviewer() {
        this(0);
    }

    public QESCertificateReviewer(int severity) {
        this.severity = severity;
    }

    protected void addTrustServiceInfo(VSQualificationCertificate qcState, IX509Certificate certificate, IX509CertificatePath path, IValidationParameters params) {
        ITrustService trustService;
        QCInfo qcInfo = (QCInfo)qcState.getQcInfo();
        IX509PublicKeyCertificate issuerCertificate = path.getIssuerCertificate(certificate);
        if (issuerCertificate != null && (issuerCertificate = (IX509PublicKeyCertificate)StandardCertificateProviderTools.lookupStoredCertificate(params.getTrustedCerts(), issuerCertificate)) != null && (trustService = TrustServiceTools.getTrustService(issuerCertificate)) != null) {
            if (trustService.isQcCompliant()) {
                qcInfo.setQcCompliant(true);
            }
            if (trustService.isStoredOnQSCD()) {
                qcInfo.setStoredOnSSCD(true);
            }
            if (qcInfo.getQcTypes().isEmpty()) {
                qcInfo.setQcTypes(new ArrayList<QCType>(trustService.getQcTypes()));
            }
        }
    }

    protected void checkCompliance(X509Extension extensionSupport, IExtensionProfileSet profileSet, CommonValidationState state) {
        ExtensionProfileValidator validator = new ExtensionProfileValidator();
        IValidationState extensionState = validator.validate(extensionSupport, profileSet);
        ((CommonValidationState)extensionState).setSeverity(1);
        state.increaseState(extensionState);
        state.addMessages(extensionState.getMessages());
    }

    protected void checkExtendedKeyPurpose(IX509Certificate certificate, Set<KeyPurposeId> requiredKeyPurposes, VSQualificationCertificate state) {
        ASN1Primitive derKeyUsage = null;
        try {
            derKeyUsage = CertificateTools.getExtensionValue(certificate, EXTENDED_KEY_USAGE);
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, EXTENDED_KEY_USAGE));
            return;
        }
        if (derKeyUsage == null) {
            state.invalidate(CommonValidationMessages.ERROR_MISSING_EXTENSION(EXTENDED_KEY_USAGE));
            return;
        }
        ExtendedKeyUsage keyUsage = ExtendedKeyUsage.getInstance((Object)derKeyUsage);
        for (KeyPurposeId id : requiredKeyPurposes) {
            if (keyUsage.hasKeyPurposeId(id)) continue;
            state.invalidate(Msg.getString("QESCertificateReviewer.InvalidKeyUsage", new Object[0]));
            break;
        }
    }

    protected ICertificateProvider deriveTrustAppBasedProvider(IValidationParameters params) {
        X509CertificateSelector selector = new X509CertificateSelector();
        if (params.getKeyPurpose() == EnumKeyPurpose.TRUSTEDLIST_SIGNING) {
            selector.setServiceTypeSelector(SimpleServiceTypeSelector.create(ServiceTypes.ST_TRUSTEDLIST));
        } else if (params.getKeyPurpose() == EnumKeyPurpose.TIMESTAMPING) {
            selector.setServiceTypeSelector(SimpleServiceTypeSelector.create(ServiceTypes.ST_QUALIFIED_TIMESTAMP));
        } else {
            selector.setServiceTypeSelector(SimpleServiceTypeSelector.create(ServiceTypes.ST_QUALIFIED_SIGNATURE));
        }
        return new PreselectCertificateProvider(selector, params.getTrustedCerts());
    }

    protected void eeBasicProcess(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate qcState, boolean validate) {
        IX509Certificate certificate = certificateState.getX509Certificate();
        if (certificate instanceof IX509PublicKeyCertificate) {
            this.eeValidateKeyCertificate((IX509PublicKeyCertificate)certificate, params, qcState);
        } else if (certificate instanceof IX509AttributeCertificate) {
            this.eeValidateAttributeCertificate((IX509AttributeCertificate)certificate, params, qcState);
        }
    }

    protected void eeCheckCompliance(IX509Certificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        IExtensionProfileSet profileSet = this.eeCreateExtensionProfileSet(certificate, params);
        this.checkCompliance(certificate, profileSet, state);
    }

    protected void eeCheckQCStatements(IX509Certificate certificate, VSQualificationCertificate qcState) {
        ASN1Sequence derQCStatements = null;
        try {
            derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, QC_STATEMENTS);
        }
        catch (IOException e) {
            qcState.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, QC_STATEMENTS));
        }
        QCInfo qcInfo = new QCInfo();
        qcState.setQcInfo(qcInfo);
        if (derQCStatements != null) {
            Enumeration e = derQCStatements.getObjects();
            while (e.hasMoreElements()) {
                ASN1Encodable derQCStatement = (ASN1Encodable)e.nextElement();
                QCStatement statement = QCStatement.getInstance((Object)derQCStatement);
                if (QCStatement.id_etsi_qcs_QcCompliance.equals((ASN1Primitive)statement.getStatementId())) {
                    qcInfo.setQcCompliant(true);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals((ASN1Primitive)statement.getStatementId()) || QCStatement.id_qcs_pkixQCSyntax_v2.equals((ASN1Primitive)statement.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals((ASN1Primitive)statement.getStatementId())) {
                    qcInfo.setStoredOnSSCD(true);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_QcType.equals((ASN1Primitive)statement.getStatementId())) {
                    ASN1Sequence typeDef = ASN1Sequence.getInstance((Object)statement.getStatementInfo());
                    ArrayList<QCType> qcTypes = new ArrayList<QCType>();
                    for (ASN1Encodable claimedType : typeDef) {
                        QCType qcType = QCType.ofOid(ASN1ObjectIdentifier.getInstance((Object)claimedType));
                        qcTypes.add(qcType);
                    }
                    qcInfo.setQcTypes(qcTypes);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_RetentionPeriod.equals((ASN1Primitive)statement.getStatementId())) {
                    ASN1Integer value = (ASN1Integer)statement.getStatementInfo();
                    qcInfo.setRetentionPeriod(value.getPositiveValue().intValue());
                    continue;
                }
                if (!QCStatement.id_etsi_qcs_LimiteValue.equals((ASN1Primitive)statement.getStatementId())) continue;
                MonetaryValue limit = MonetaryValue.getInstance((Object)statement.getStatementInfo());
                Iso4217CurrencyCode currency = limit.getCurrency();
                double value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
                if (currency.isAlphabetic()) {
                    qcInfo.setLimitCurrency(currency.getAlphabetic());
                } else {
                    int numeric = currency.getNumeric();
                    String alphabetic = Iso4217.Numeric2Alphabetic((int)numeric);
                    qcInfo.setLimitCurrency(alphabetic);
                }
                qcInfo.setLimitValue(value);
            }
        }
    }

    protected IExtensionProfileSet eeCreateExtensionProfileSet(IX509Certificate certificate, IValidationParameters params) {
        if (certificate instanceof IX509PublicKeyCertificate) {
            return ExtensionProfileSet.createCommonPKICorePublicKeyCertificate(params.getKeyPurpose());
        }
        return ExtensionProfileSet.createDefault();
    }

    protected void eeValidateAttributeCertificate(IX509AttributeCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
    }

    protected void eeValidateKeyCertificate(IX509PublicKeyCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        EnumKeyPurpose keyPurpose = params.getKeyPurpose();
        if (keyPurpose == EnumKeyPurpose.DIGITAL_SIGNATURE) {
            this.eeValidateSign(certificate, params, state);
        } else if (keyPurpose == EnumKeyPurpose.TIMESTAMPING) {
            this.eeValidateTimestamp(certificate, params, state);
        }
    }

    protected void eeValidateSign(IX509PublicKeyCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
    }

    protected void eeValidateTimestamp(IX509PublicKeyCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        HashSet<KeyPurposeId> requiredKeyPurposeIds = new HashSet<KeyPurposeId>();
        requiredKeyPurposeIds.add(KeyPurposeId.id_kp_timeStamping);
        this.checkExtendedKeyPurpose(certificate, requiredKeyPurposeIds, state);
    }

    protected Date getDateOfCertGen(IX509Certificate certificate, VSQualificationCertificate state) {
        try {
            ASN1Primitive derDateOfCertGen = CertificateTools.getExtensionValue(certificate, "1.3.36.8.3.1");
            ASN1GeneralizedTime dateOfCertGen = ASN1GeneralizedTime.getInstance((Object)derDateOfCertGen);
            if (dateOfCertGen == null) {
                return null;
            }
            return dateOfCertGen.getDate();
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "1.3.36.8.3.1"));
        }
        catch (ParseException e) {
            state.invalidate(e.getLocalizedMessage());
        }
        return null;
    }

    public int getSeverity() {
        return this.severity;
    }

    protected abstract CommonPKIProfile getValidityPolicy();

    protected void issuerBasicProcess(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate qcState, boolean validate) {
    }

    protected void issuerCheckBasicConstraints(IX509Certificate certificate, VSQualificationCertificate qcState) {
        ASN1Primitive derBasicConstraints = null;
        try {
            derBasicConstraints = CertificateTools.getExtensionValue(certificate, BASIC_CONSTRAINTS);
        }
        catch (IOException e) {
            qcState.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, BASIC_CONSTRAINTS));
            return;
        }
        if (derBasicConstraints == null) {
            qcState.addMessage(CommonValidationMessages.WARNING_MISSING_EXTENSION(BASIC_CONSTRAINTS));
        }
    }

    protected void issuerCheckCompliance(IX509Certificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        IExtensionProfileSet profileSet = this.issuerCreateExtensionProfileSet(certificate, params);
        this.checkCompliance(certificate, profileSet, state);
    }

    protected void issuerCheckKeyUsage(IX509Certificate certificate, VSQualificationCertificate qcState) {
        DERBitString keyUsage;
        ASN1Primitive derKeyUsage = null;
        try {
            derKeyUsage = CertificateTools.getExtensionValue(certificate, KEY_USAGE);
        }
        catch (IOException e) {
            qcState.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, KEY_USAGE));
            return;
        }
        if (derKeyUsage == null) {
            qcState.invalidate(CommonValidationMessages.ERROR_MISSING_EXTENSION(KEY_USAGE));
            return;
        }
        if (!CertificateTools.isCriticalExtension(certificate, KEY_USAGE)) {
            qcState.invalidate(CommonValidationMessages.ERROR_EXTENSION_NOT_CRITICAL(KEY_USAGE));
        }
        if (((keyUsage = DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)derKeyUsage))).intValue() | 4 | 2) != 6) {
            qcState.addMessage(ValidationMessage.createWarning(Msg.getString("QESCertificateReviewer.InvalidIssuerKeyUsage", new Object[0])));
        }
    }

    protected IExtensionProfileSet issuerCreateExtensionProfileSet(IX509Certificate certificate, IValidationParameters params) {
        return ExtensionProfileSet.createCommonPKICorePublicKeyCertificate(params.getKeyPurpose());
    }

    protected void pathBasicValidate(IX509Certificate certificate, IX509CertificatePath path, IValidationParameters params, VSCertificate certificateState, VSQualificationCertificate qcState) {
        IQCInfo qcInfo = qcState.getQcInfo();
        boolean qcCompliant = false;
        if (qcInfo != null && qcInfo.isQcCompliant()) {
            qcCompliant = true;
        }
        IX509Certificate qcRoot = null;
        List<IX509Certificate> list = path.getPath();
        ListIterator<IX509Certificate> it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            IX509Certificate e = it.previous();
            IX509Certificate trustedEntry = StandardCertificateProviderTools.lookupStoredCertificate(params.getTrustedCerts(), e);
            if (trustedEntry == null) continue;
            qcRoot = trustedEntry;
            break;
        }
        if (qcRoot == null) {
            if (!qcCompliant) {
                qcState.invalidate(ValidationMessage.createError(Msg.getString("QESCertificateReviewer.InvalidPath", new Object[0])));
            }
        } else {
            IX509Certificate trustAnchor;
            if (!qcCompliant) {
                qcState.addMessage(ValidationMessage.createInfo(Msg.getString("QESCertificateReviewer.ValidPath", new Object[0])));
            }
            if (qcRoot != (trustAnchor = certificateState.getCertificatePathState().getTrustAnchor())) {
                VSCertificatePath pathState = new VSCertificatePath(certificateState.getCertificatePathState());
                pathState.setTrustAnchor(qcRoot);
                certificateState.setCertificatePathState(pathState);
            }
        }
    }

    protected void processEndEntityCertificate(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate state, boolean validate) {
        IX509Certificate certificate = certificateState.getX509Certificate();
        this.eeCheckQCStatements(certificate, state);
        this.eeBasicProcess(certificateState, params, state, validate);
        if (validate) {
            this.eeCheckCompliance(certificate, params, state);
        }
    }

    protected void processIssuerCertificate(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate state, boolean validate) {
        IX509Certificate certificate = certificateState.getX509Certificate();
        if (validate) {
            this.issuerCheckKeyUsage(certificate, state);
            this.issuerCheckBasicConstraints(certificate, state);
        }
        this.issuerBasicProcess(certificateState, params, state, validate);
        if (validate) {
            this.issuerCheckCompliance(certificate, params, state);
        }
    }

    protected void processRootCertificate(IX509Certificate certificate, IValidationParameters params, VSQualificationCertificate state, boolean validate) {
        this.rootBasicProcess(certificate, params, state, validate);
    }

    @Override
    public IVSCertificate review(IX509Certificate certificate, IVSCertificate state, IValidationParameters params) {
        if (certificate == null) {
            return state;
        }
        if (params.getKeyPurpose() == EnumKeyPurpose.OCSP_SIGNING || params.getKeyPurpose() == EnumKeyPurpose.CRL_SIGNING) {
            return state;
        }
        ValidationParameters localParams = ValidationParameters.copy(params);
        ICertificateProvider trustApptrustAnchors = this.deriveTrustAppBasedProvider(params);
        localParams.setTrustedCerts(trustApptrustAnchors);
        IVSCertificatePath pathState = state.getCertificatePathState();
        if (pathState == null) {
            return state;
        }
        IX509CertificatePath path = pathState.getCertPath();
        if (path == null || path.size() == 0) {
            return state;
        }
        VSCertificate certState = new VSCertificate(state);
        this.validate(certificate, pathState, localParams, certState);
        return certState;
    }

    protected void rootBasicProcess(IX509Certificate certificate, IValidationParameters params, VSQualificationCertificate qcState, boolean validate) {
    }

    protected void validate(IX509Certificate certificate, IVSCertificatePath pathState, IValidationParameters params, VSCertificate state) {
        VSQualificationCertificate qcState = new VSQualificationCertificate(0);
        qcState.setSeverity(this.getSeverity());
        qcState.setValidityPolicyID(this.getValidityPolicy());
        boolean validate = true;
        ReverseListIterator i = new ReverseListIterator(pathState.getCertificateStates());
        while (i.hasNext()) {
            IVSCertificate currentCertificateState = (IVSCertificate)i.next();
            IX509Certificate currentCertificate = currentCertificateState.getX509Certificate();
            if (validate && params.getTrustedCerts().containsCertificate(currentCertificate)) {
                validate = false;
            }
            if (currentCertificate.equals(certificate)) {
                this.processEndEntityCertificate(currentCertificateState, params, qcState, validate);
            } else {
                this.processIssuerCertificate(currentCertificateState, params, qcState, validate);
            }
            if (i.hasNext()) continue;
            this.processRootCertificate(currentCertificate, params, qcState, validate);
        }
        this.addTrustServiceInfo(qcState, certificate, pathState.getCertPath(), params);
        this.pathBasicValidate(certificate, pathState.getCertPath(), params, state, qcState);
        state.setQcState(qcState);
    }
}

