/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.crypto;

import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.crypto.CryptoValidator;
import de.intarsys.security.app.validation.commonpki.crypto.PACKAGE;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.ValidationAspect;
import de.intarsys.security.validation.IVSCrypto;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.message.IMessageBundle;
import java.util.Date;
import java.util.Optional;

public class AdESCryptoSignatureContainerEntryReviewer
implements IReviewer<ISignatureContainerEntry, IVSSignatureContainerEntry> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private CryptoValidator validator;

    public AdESCryptoSignatureContainerEntryReviewer() {
    }

    public AdESCryptoSignatureContainerEntryReviewer(CryptoValidator validator) {
        this.validator = validator;
    }

    public synchronized CryptoValidator getValidator() {
        if (this.validator == null) {
            this.validator = new CryptoValidator();
        }
        return this.validator;
    }

    @Override
    public IVSSignatureContainerEntry review(ISignatureContainerEntry entry, IVSSignatureContainerEntry state, IValidationParameters params) {
        if (entry == null || state == null) {
            return state;
        }
        Date referenceDate = Optional.ofNullable(state.getCreationDate()).orElseGet(() -> new Date());
        IVSCrypto cryptoState = this.getValidator().validate(state, referenceDate);
        CommonValidationState modifiableState = (CommonValidationState)((Object)state);
        modifiableState.addAspect(ValidationAspect.with(IVSCrypto.class, (IValidationState)cryptoState));
        if (cryptoState.isInvalid() || cryptoState.isUnknown()) {
            modifiableState.setState(2);
        }
        return state;
    }
}

