/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.ITimestampValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class CommonPKITimestampValidator
implements ITimestampValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final List<EnumKeyPurpose> acceptedKeyPurposes = new ArrayList<EnumKeyPurpose>();

    public void addAcceptedKEyPurpose(EnumKeyPurpose keyPurpose) {
        this.acceptedKeyPurposes.add(keyPurpose);
    }

    protected List<EnumKeyPurpose> getAcceptedKeyPurposes() {
        return new ArrayList<EnumKeyPurpose>(this.acceptedKeyPurposes);
    }

    @Override
    public IVSTimestamp validate(ITimestampToken timestamp, IDigest digest, IValidationParameters parameters) {
        VSTimestamp timestampState = new VSTimestamp(timestamp);
        ITimestampInfo timestampInfo = null;
        try {
            timestampInfo = timestamp.getTimestampInfo();
            if (timestampInfo == null) {
                timestampState.invalidate(Msg.getString("CommonPKITimestampValidator.errorMissingTimestampInfo", new Object[0]));
            }
        }
        catch (IOException e) {
            timestampState.invalidate(CommonValidationMessages.ERROR_IO(e));
        }
        ISignatureContainer<?> signatures = timestamp.getSignatureContainer();
        if (signatures == null || signatures.getSize() == 0) {
            timestampState.invalidate(Msg.getString("CommonPKITimestampValidator.errorMissingSignatures", new Object[0]));
        }
        if (timestampInfo == null || signatures == null) {
            return timestampState;
        }
        Date referenceDate = timestampInfo.getGenTime();
        IVSSignatureContainer containerState = this.validateSignatures(signatures, referenceDate, parameters);
        timestampState.setSignatureState(containerState);
        IVSDigest digestState = this.validateDigest(timestampInfo, digest);
        timestampState.setDigestState(digestState);
        return timestampState;
    }

    protected IVSDigest validateDigest(ITimestampInfo timestampInfo, IDigest digest) {
        VSDigest digestState = new VSDigest(-1);
        byte[] signedHash = timestampInfo.getMessageImprintHash();
        digestState.setReferenceDigest(signedHash);
        String signedHashAlg = timestampInfo.getMessageImprintAlgorithmOID();
        String digestAlgorithmName = SignatureAlgorithm.getHashAlgorithmName(signedHashAlg);
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(digestAlgorithmName);
        AlgorithmSpec<DigestAlgorithm> digestAlgorithmSpec = new AlgorithmSpec<DigestAlgorithm>(digestAlgorithm);
        digestState.setAlgorithmSpec(digestAlgorithmSpec);
        if (digest == null) {
            return digestState;
        }
        byte[] currentHash = digest.getBytes();
        digestState.setCalculatedDigest(currentHash);
        if (Arrays.equals(signedHash, currentHash)) {
            digestState.addMessage(CommonValidationMessages.INFO_DIGEST_VERIFIED_TRUE());
            digestState.increaseState(0);
        } else {
            digestState.invalidate(CommonValidationMessages.ERROR_DIGEST_VERIFIED_FALSE());
        }
        return digestState;
    }

    protected IVSSignatureContainer validateSignatures(ISignatureContainer signatures, Date referenceDate, IValidationParameters parameters) {
        ValidationParameters localParameters = ValidationParameters.copy(parameters);
        localParameters.setDateToTest(referenceDate, true);
        localParameters.setKeyPurpose(EnumKeyPurpose.TIMESTAMPING);
        IVSSignatureContainer containerState = ValidationContext.get().getSignatureContainerValidator().validate(signatures, null, localParameters);
        return containerState;
    }
}

