/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCRLRequest;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.IVSRevocationRequest;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.security.validation.IVSTimestampEntry;
import de.intarsys.security.validation.IValidationState;

public abstract class ValidationStateWalker {
    protected ValidationStateWalker() {
    }

    protected void basicVisit(IVSCertificate state) {
        if (state.getOCSPState() != null) {
            this.visit(state.getOCSPState());
        }
        if (state.getCRLState() != null) {
            this.visit(state.getCRLState());
        }
    }

    public void visit(IValidationState state) {
        if (state instanceof IVSSignatureContainer) {
            this.visit((IVSSignatureContainer)state);
        } else if (state instanceof IVSSignatureEntry) {
            this.visit((IVSSignatureEntry)state);
        } else if (state instanceof IVSTimestampEntry) {
            this.visit((IVSTimestampEntry)state);
        } else if (state instanceof IVSTimestamp) {
            this.visit((IVSTimestamp)state);
        } else if (state instanceof IVSCertificate) {
            this.visit((IVSCertificate)state);
        } else if (state instanceof IVSCertificatePath) {
            this.visit((IVSCertificatePath)state);
        } else if (state instanceof IVSCRL) {
            this.visit((IVSCRL)state);
        } else if (state instanceof IVSCRLRequest) {
            this.visit((IVSCRLRequest)state);
        } else if (state instanceof IVSOCSP) {
            this.visit((IVSOCSP)state);
        } else if (state instanceof IVSOCSPRequest) {
            this.visit((IVSOCSPRequest)state);
        }
    }

    public void visit(IVSCertificate state) {
        if (state.getCertificatePathState() == null) {
            this.basicVisit(state);
        } else {
            this.visit(state.getCertificatePathState());
        }
    }

    public void visit(IVSCertificatePath state) {
        for (IVSCertificate certificateState : state.getCertificateStates()) {
            this.visit(certificateState);
        }
    }

    public void visit(IVSCRL state) {
        for (IVSRevocationRequest requestState : state.getRequestStates()) {
            this.visit(requestState);
        }
    }

    public void visit(IVSCRLRequest state) {
        if (state.getCertificateState() != null) {
            this.visit(state.getCertificateState());
        }
    }

    public void visit(IVSOCSP state) {
        for (IVSRevocationRequest requestState : state.getRequestStates()) {
            this.visit(requestState);
        }
    }

    public void visit(IVSOCSPRequest state) {
        if (state.getCertificateState() != null) {
            this.visit(state.getCertificateState());
        }
    }

    public void visit(IVSSignatureContainer state) {
        for (IVSSignatureContainerEntry entryState : state.getEntryStates()) {
            this.visit(entryState);
        }
    }

    public void visit(IVSSignatureEntry state) {
        if (state.getCertificateState() != null) {
            this.visit(state.getCertificateState());
        }
        for (IVSCertificate certificateState : state.getAttributeCertificateStates()) {
            this.visit(certificateState);
        }
        for (IVSTimestamp timestampState : state.getTimestampStates()) {
            this.visit(timestampState);
        }
    }

    public void visit(IVSTimestamp state) {
        if (state.getSignatureState() != null) {
            this.visit(state.getSignatureState());
        }
    }

    public void visit(IVSTimestampEntry state) {
        if (state.getTimestampState() != null) {
            this.visit(state.getTimestampState());
        }
    }
}

