/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.validation.IValidationState;
import java.util.ArrayList;
import java.util.List;

public abstract class DecoratedValidator<S, T extends IValidationState, BV, R extends IReviewer<S, T>> {
    private BV basicValidator;
    private List<R> reviewers = new ArrayList<R>();

    public DecoratedValidator(BV basicValidator) {
        this.basicValidator = basicValidator;
    }

    public void addReviewer(R reviewer) {
        this.reviewers.add(reviewer);
    }

    public BV getBasicValidator() {
        return this.basicValidator;
    }

    public List<R> getReviewers() {
        return new ArrayList<R>(this.reviewers);
    }

    public void removeReviewer(R reviewer) {
        this.reviewers.remove(reviewer);
    }

    protected T review(S object, T state, IValidationParameters params) {
        for (IReviewer reviewer : this.getReviewers()) {
            state = reviewer.review(object, state, params);
        }
        return state;
    }
}

