/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.rsa;

import de.intarsys.security.encoding.EncodingTools;
import de.intarsys.security.encoding.IEncoding;
import de.intarsys.security.encoding.NoopEncoding;
import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class RsaTools {
    public static final String RSA_PKCS1_ECB = "RSA/ECB/PKCS1PADDING";
    public static final String RSA_PKCS1_NONE = "RSA/NONE/PKCS1PADDING";

    public static void checkKeys(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        Random random = new Random();
        byte[] bytes = new byte[100];
        for (int i = 0; i < 10; ++i) {
            random.nextBytes(bytes);
            byte[] encrypted = RsaTools.encrypt(bytes, publicKey);
            byte[] decrypted = RsaTools.decrypt(encrypted, privateKey);
            if (Arrays.equals(bytes, decrypted)) continue;
            throw new IllegalArgumentException();
        }
    }

    public static byte[] decrypt(byte[] bytes, Key key) throws GeneralSecurityException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/NONE/NoPadding", "BC");
            cipher.init(2, key);
            return cipher.doFinal(bytes);
        }
        catch (RuntimeException e) {
            throw new GeneralSecurityException(e.getLocalizedMessage(), e);
        }
    }

    public static byte[] encrypt(byte[] bytes, Key key) throws GeneralSecurityException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/NONE/NoPadding", "BC");
            cipher.init(1, key);
            return cipher.doFinal(bytes);
        }
        catch (RuntimeException e) {
            throw new GeneralSecurityException(e.getLocalizedMessage(), e);
        }
    }

    public static int getExpectedSignatureSize(PublicKey publicKey) {
        return RsaTools.getKeyByteSize(publicKey);
    }

    public static int getKeyBitSize(PublicKey publicKey) {
        return ((RSAPublicKey)publicKey).getModulus().bitLength();
    }

    public static int getKeyByteSize(PublicKey publicKey) {
        return (RsaTools.getKeyBitSize(publicKey) + 7) / 8;
    }

    public static PrivateKey loadPrivateKey(ILocator locator, ICryptdec cryptdec) throws IOException, GeneralSecurityException {
        byte[] encrypted = LocatorTools.getBytes((ILocator)locator);
        byte[] encoded = cryptdec.decrypt(encrypted);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey loadPublicKey(ILocator locator) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        byte[] encoded = LocatorTools.getBytes((ILocator)locator);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
        return keyFactory.generatePublic(keySpec);
    }

    public static Cipher lookupRSACipher() throws NoSuchAlgorithmException {
        return RsaTools.lookupRSACipher("BC");
    }

    public static Cipher lookupRSACipher(String provider) throws NoSuchAlgorithmException {
        try {
            try {
                return Cipher.getInstance(RSA_PKCS1_NONE, provider);
            }
            catch (NoSuchAlgorithmException e) {
                return Cipher.getInstance(RSA_PKCS1_ECB, provider);
            }
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePrivateKey(ILocator locator, PrivateKey key, ICryptdec cryptdec) throws IOException, GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key.getEncoded());
        try (OutputStream os = locator.getOutputStream();){
            os.write(cryptdec.encrypt(keySpec.getEncoded()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePublicKey(ILocator locator, PublicKey key) throws IOException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key.getEncoded());
        try (OutputStream os = locator.getOutputStream();){
            os.write(keySpec.getEncoded());
        }
    }

    public static boolean validate(byte[] signature, PublicKey key, AlgorithmParameterSpec paramSpec, byte[] message) throws GeneralSecurityException, IOException {
        if (message == null || signature == null) {
            return false;
        }
        byte[] encrypted = RsaTools.encrypt(signature, key);
        IEncoding encoding = EncodingTools.createEncoding(paramSpec);
        if (encoding == null) {
            encoding = EncodingTools.guessEncoding(encrypted);
        }
        if (encoding == null) {
            encoding = new NoopEncoding();
        }
        return encoding.match(message, encrypted);
    }

    private RsaTools() {
    }
}

