/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.zones;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.zones.IZone;
import de.intarsys.tools.zones.StandardZone;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Singleton
public final class Zone {
    private static final ThreadLocal<Deque<IZone>> CURRENT = new ForwardedThreadLocal(){

        @Override
        protected Object initialValue() {
            return new ArrayDeque();
        }
    };
    private static final StandardZone ROOT_ZONE = new StandardZone("root", null);

    protected static int count(IZone zone) {
        Deque<IZone> deque = CURRENT.get();
        return (int)deque.stream().filter(z -> zone == z).count();
    }

    public static IZone getCurrent() {
        Deque<IZone> zones = CURRENT.get();
        IZone temp = zones.peek();
        if (temp == null) {
            temp = ROOT_ZONE;
        }
        return temp;
    }

    public static IZone getRoot() {
        return ROOT_ZONE;
    }

    protected static IZone peek() {
        return CURRENT.get().peek();
    }

    protected static void pop() {
        Deque<IZone> stack = CURRENT.get();
        stack.pop();
        if (stack.isEmpty()) {
            CURRENT.remove();
        }
    }

    protected static int push(IZone zone) {
        Deque<IZone> deque = CURRENT.get();
        deque.push(zone);
        return Zone.count(zone);
    }

    private Zone() {
    }

    protected static <R> Callable<R> createCallable(final IZone zone, final Callable<R> functionalInterface) {
        return new Callable<R>(){

            @Override
            public R call() throws Exception {
                try {
                    zone.enter();
                    Object v = functionalInterface.call();
                    return v;
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static <T> Consumer<T> createConsumer(final IZone zone, final Consumer<T> functionalInterface) {
        return new Consumer<T>(){

            @Override
            public void accept(T value) {
                try {
                    zone.enter();
                    functionalInterface.accept(value);
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static <T, E extends Exception> Throwing.Consumer<T> createConsumer(final IZone zone, final Throwing.Specific.Consumer<T, E> functionalInterface) {
        return new Throwing.Consumer<T>(){

            @Override
            public void accept(T value) throws Exception {
                try {
                    zone.enter();
                    functionalInterface.accept(value);
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static <T, R> Function<T, R> createFunction(final IZone zone, final Function<T, R> functionalInterface) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                try {
                    zone.enter();
                    Object r = functionalInterface.apply(value);
                    return r;
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static <T, R, E extends Exception> Throwing.Specific.Function<T, R, E> createFunction(final IZone zone, final Throwing.Specific.Function<T, R, E> functionalInterface) {
        return new Throwing.Specific.Function<T, R, E>(){

            @Override
            public R apply(T value) throws Exception {
                try {
                    zone.enter();
                    Object r = functionalInterface.apply(value);
                    return r;
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static Runnable createRunnable(final IZone zone, final Runnable functionalInterface) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    zone.enter();
                    functionalInterface.run();
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static <R> Supplier<R> createSupplier(final IZone zone, final Supplier<R> functionalInterface) {
        return new Supplier<R>(){

            @Override
            public R get() {
                try {
                    zone.enter();
                    Object t = functionalInterface.get();
                    return t;
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    protected static <R, E extends Exception> Throwing.Supplier<R> createSupplier(final IZone zone, final Throwing.Specific.Supplier<R, E> functionalInterface) {
        return new Throwing.Supplier<R>(){

            @Override
            public R get() throws Exception {
                try {
                    zone.enter();
                    Object t = functionalInterface.get();
                    return t;
                }
                finally {
                    zone.leave();
                }
            }
        };
    }

    public static <V> Callable<V> wrap(IZone zone, Callable<V> functionalInterface) {
        return Zone.createCallable(zone, functionalInterface);
    }

    public static <T> Consumer<T> wrap(IZone zone, Consumer<T> functionalInterface) {
        return Zone.createConsumer(zone, functionalInterface);
    }

    public static <T, R> Function<T, R> wrap(IZone zone, Function<T, R> functionalInterface) {
        return Zone.createFunction(zone, functionalInterface);
    }

    public static Runnable wrap(IZone zone, Runnable functionalInterface) {
        return Zone.createRunnable(zone, functionalInterface);
    }

    public static <T> Supplier<T> wrap(IZone zone, Supplier<T> functionalInterface) {
        return Zone.createSupplier(zone, functionalInterface);
    }

    public static <T, E extends Throwable> Throwing.Specific.Consumer<T, E> wrap(IZone zone, Throwing.Specific.Consumer<T, E> functionalInterface) {
        return Zone.createConsumer(zone, functionalInterface);
    }

    public static <T, R, E extends Throwable> Throwing.Specific.Function<T, R, E> wrap(IZone zone, Throwing.Specific.Function<T, R, E> functionalInterface) {
        return Zone.createFunction(zone, functionalInterface);
    }

    public static <T, E extends Throwable> Throwing.Specific.Supplier<T, E> wrap(IZone zone, Throwing.Specific.Supplier<T, E> functionalInterface) {
        return Zone.createSupplier(zone, functionalInterface);
    }
}

