/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.xfs;

import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.xfs.IXFSNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class XFSClassLoaderNode
implements IXFSNode {
    private final ClassLoader classLoader;
    private final String path;
    private final String metaPath;
    private final String name;
    private final String container;
    private List<IXFSNode> children;

    public XFSClassLoaderNode(ClassLoader classLoader) {
        this(classLoader, null, "", "META-INF/x-fs/ROOT", "");
    }

    protected XFSClassLoaderNode(ClassLoader classLoader, String container, String path, String metaPath, String name) {
        this.classLoader = classLoader;
        this.container = container;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        this.metaPath = metaPath;
        this.name = name;
    }

    protected XFSClassLoaderNode basicCreateChildNode(String container, String childName) {
        String pathName = this.getPath() + this.getName() + "/";
        String metaPathName = this.getMetaPath() + this.getName() + "/children/";
        XFSClassLoaderNode childNode = new XFSClassLoaderNode(this.getClassLoader(), container, pathName, metaPathName, childName);
        return childNode;
    }

    @Override
    public int compareTo(IXFSNode o) {
        return this.getName().compareTo(o.getName());
    }

    protected XFSClassLoaderNode createChild(String container, String childName) {
        if (StringTools.isEmpty(childName)) {
            return null;
        }
        String[] segments = childName.split("[\\\\/]");
        XFSClassLoaderNode childNode = this;
        for (String segment : segments) {
            childNode = childNode.basicCreateChildNode(container, segment);
        }
        return childNode;
    }

    protected List<IXFSNode> createChildren() throws IOException {
        ArrayList<String> containerNames = new ArrayList<String>();
        ArrayList<IXFSNode> result = new ArrayList<IXFSNode>();
        String dirname = this.getMetaPath() + this.getName() + "/directory.txt";
        Enumeration<URL> urls = this.getClassLoader().getResources(dirname);
        while (urls.hasMoreElements()) {
            String[] childNames;
            URL url = urls.nextElement();
            String containerName = url.toString();
            int index = containerName.indexOf(dirname);
            if (index >= 0) {
                containerName = containerName.substring(0, index);
            }
            if (containerNames.contains(containerName)) continue;
            containerNames.add(containerName);
            InputStream is = url.openStream();
            if (is == null) continue;
            String directory = StreamTools.getString(is, StandardCharsets.UTF_8);
            for (String childName : childNames = directory.split("\\n")) {
                XFSClassLoaderNode childNode = this.createChild(containerName, childName.trim());
                if (childNode == null) continue;
                result.add(childNode);
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean exists() {
        String filename = this.getPath() + this.getName();
        InputStream is = this.getClassLoader().getResourceAsStream(filename);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public XFSClassLoaderNode getChild(String childName) {
        return this.createChild(null, childName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IXFSNode> getChildren() throws IOException {
        XFSClassLoaderNode xFSClassLoaderNode = this;
        synchronized (xFSClassLoaderNode) {
            if (this.children == null) {
                this.children = this.createChildren();
            }
            return this.children;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContainer() {
        return this.container;
    }

    public String getMetaPath() {
        return this.metaPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getContainer() + this.getPath() + this.getName();
    }
}

