/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.variable;

import de.intarsys.tools.bean.IBeanInstallationInstruction;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.NullPreferences;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.variable.IVariableNamespace;
import de.intarsys.tools.variable.IVariableNamespaces;
import de.intarsys.tools.variable.VariableNamespaces;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;

public class VariableNamespace
implements IVariableNamespace,
IPreferencesSupport,
IElementConfigurable,
IBeanInstallationInstruction {
    private static final String NA = new String();
    private Map<String, String> namespace = new HashMap<String, String>();
    private IPreferences preferences;
    private String preferencesName;
    private String preferencesScope;
    private String id;

    public String basicGetVariable(String key) {
        return this.namespace.get(key);
    }

    public Map basicGetVariables() {
        HashMap<String, String> result = new HashMap<String, String>(this.namespace);
        return result;
    }

    public void basicPutVariable(String key, String value) {
        this.namespace.put(key, value);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.setId(element.attributeValue("id", this.getId()));
        this.setPreferencesName(element.attributeValue("preferences", this.getPreferencesName()));
        this.setPreferencesScope(element.attributeValue("preferencesscope", this.getPreferencesScope()));
    }

    protected IPreferences createPreferences() {
        if (this.preferencesName == null) {
            return NullPreferences.ACTIVE;
        }
        IPreferences tempPrefs = PreferencesFactory.get().getRoot().node(this.preferencesName);
        if (this.preferencesScope != null) {
            tempPrefs = tempPrefs.restrict(this.preferencesScope);
        }
        return tempPrefs;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    public String getPreferencesName() {
        return this.preferencesName;
    }

    public String getPreferencesScope() {
        return this.preferencesScope;
    }

    @Override
    public String getVariable(String key) {
        String result = this.getPreferences().get(key, NA);
        if (result == NA) {
            result = this.namespace.get(key);
        }
        return result;
    }

    @Override
    public String getVariable(String key, String defaultValue) {
        String result = this.getPreferences().get(key, NA);
        if (result == NA && (result = this.namespace.get(key)) == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Iterator getVariableIterator() {
        return this.getVariables().entrySet().iterator();
    }

    @Override
    public Map getVariables() {
        HashMap<String, String> result = new HashMap<String, String>(this.namespace);
        result.putAll(this.getPreferences().properties());
        return result;
    }

    @Override
    public void putVariable(String key, String value) {
        this.getPreferences().put(key, value);
    }

    @PostConstruct
    public void register() {
        if (StringTools.isEmpty(this.getId())) {
            return;
        }
        IVariableNamespaces namespaces = VariableNamespaces.get();
        namespaces.setNamespace(this.getId(), this);
    }

    public void reset() {
        try {
            this.getPreferences().clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPreferencesName(String preferencesName) {
        this.preferencesName = preferencesName;
    }

    public void setPreferencesScope(String preferencesScope) {
        this.preferencesScope = preferencesScope;
    }
}

