/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui.selection;

import de.intarsys.tools.ui.selection.ISelection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class SelectionTools {
    protected static final Attribute UNDEFINED = new Attribute();

    public static <T> boolean check(ISelection<T> selection, Predicate<Object> check) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return selection.getElements().stream().allMatch(check);
    }

    public static <T> Attribute<T> getCommonAttribute(ISelection<T> selection, Function<T, T> performer) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                if (arg0 == null) {
                    return arg1 == null ? 0 : 1;
                }
                return arg0.equals(arg1) ? 0 : 1;
            }
        };
        return SelectionTools.getCommonAttribute(selection, performer, comparator);
    }

    public static <T> Attribute<T> getCommonAttribute(ISelection<T> selection, Function<T, T> performer, Comparator<T> comparator) {
        Attribute commonValue = UNDEFINED;
        for (T element : selection.getElements()) {
            T elementValue = performer.apply(element);
            if (commonValue.isUndefined()) {
                commonValue = new Attribute(elementValue, comparator);
                continue;
            }
            if (commonValue.hasValue(elementValue)) continue;
            commonValue = UNDEFINED;
            break;
        }
        return commonValue;
    }

    public static <T> Attribute<T> getCommonAttribute(List<T> objects, Function<T, T> performer) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                if (arg0 == null) {
                    return arg1 == null ? 0 : 1;
                }
                return arg0.equals(arg1) ? 0 : 1;
            }
        };
        return SelectionTools.getCommonAttribute(objects, performer, comparator);
    }

    public static <T> Attribute<T> getCommonAttribute(List<T> objects, Function<T, T> performer, Comparator<T> comparator) {
        Attribute commonValue = UNDEFINED;
        for (T element : objects) {
            T elementValue = performer.apply(element);
            if (commonValue.isUndefined()) {
                commonValue = new Attribute(elementValue, comparator);
                continue;
            }
            if (commonValue.hasValue(elementValue)) continue;
            commonValue = UNDEFINED;
            break;
        }
        return commonValue;
    }

    public static <T> boolean hasType(ISelection<T> selection, Class<?> type) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (type == null) {
            return true;
        }
        return SelectionTools.check(selection, element -> type.isInstance(element));
    }

    public static <T> void perform(ISelection<T> selection, Consumer<Object> performer) {
        if (selection == null) {
            return;
        }
        for (T element : selection.getElements()) {
            try {
                performer.accept(element);
            }
            catch (SelectionPerformerBreak e) {
                break;
            }
        }
    }

    private SelectionTools() {
    }

    public static class Attribute<T> {
        private Comparator<T> comparator;
        private boolean undefined;
        private T value;

        public Attribute() {
            this.undefined = true;
        }

        public Attribute(T value, Comparator<T> comparator) {
            this.value = value;
            this.undefined = false;
            this.comparator = comparator;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean hasValue(T obj) {
            if (this.isUndefined()) {
                return false;
            }
            return this.comparator.compare(this.value, obj) == 0;
        }

        public boolean isUndefined() {
            return this.undefined;
        }
    }

    public static class SelectionPerformerBreak
    extends RuntimeException {
    }

    public static interface ISelectionPerformer<T>
    extends Function<T, T>,
    Consumer<T> {
        @Override
        default public void accept(T t) {
            this.perform(t);
        }

        @Override
        default public T apply(T t) {
            return this.perform(t);
        }

        public T perform(T var1);
    }

    public static interface ISelectionCheck<T>
    extends Predicate<T> {
        public boolean accept(T var1);

        @Override
        default public boolean test(T t) {
            return this.accept(t);
        }
    }
}

