/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui.selection;

import de.intarsys.tools.ui.selection.EmptySelection;
import de.intarsys.tools.ui.selection.ISelection;
import de.intarsys.tools.ui.selection.ListSelection;
import de.intarsys.tools.ui.selection.SingleObjectSelection;
import java.util.Arrays;
import java.util.List;

public abstract class CommonSelection<T>
implements ISelection<T> {
    public static <T> ISelection<T> createFromTarget(T target) {
        if (target == null) {
            return new EmptySelection();
        }
        if (target instanceof List) {
            return new ListSelection((List)target);
        }
        if (target.getClass().isArray()) {
            return new ListSelection<Object>(Arrays.asList((Object[])target));
        }
        return new SingleObjectSelection<T>(target);
    }

    public static <T> ISelection<T> createFromTargets(T ... target) {
        if (target == null || target.length == 0) {
            return new EmptySelection();
        }
        if (target.length == 1) {
            return new SingleObjectSelection<T>(target[0]);
        }
        return new ListSelection<T>(Arrays.asList(target));
    }

    protected CommonSelection() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISelection)) {
            return false;
        }
        ISelection partner = (ISelection)obj;
        return this.getElements().equals(partner.getElements());
    }

    public int hashCode() {
        return this.getElements().hashCode();
    }
}

