/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tag;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.TagResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.tag.ITagSupport;
import de.intarsys.tools.tag.Tag;
import de.intarsys.tools.tag.TagList;
import de.intarsys.tools.zones.Zone;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagTools {
    private static final Logger Log = LoggerFactory.getLogger(TagTools.class);
    public static final String RESOLVER_NS_TAGS = "tags";
    private static final Attribute ATTR_TAGS = new Attribute("tags");
    private static final List<Tag> EMPTY = Collections.emptyList();
    private static final Map<Object, List<Tag>> TAGS_MAP = new WeakHashMap<Object, List<Tag>>();

    public static void addTag(Object object, String key, String value) {
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.add(new Tag(key, value));
    }

    public static void addTag(Object object, Tag tag) {
        if (tag == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.add(tag);
    }

    public static void addTags(Object object, List<Tag> pTags) {
        if (pTags == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.addAll(pTags);
    }

    public static void addTags(Object object, Map<String, String> pTags) {
        if (pTags == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        for (Map.Entry<String, String> entry : pTags.entrySet()) {
            tags.add(new Tag(entry.getKey(), entry.getValue()));
        }
    }

    public static void addTags(Object object, String tagString) {
        if (StringTools.isEmpty(tagString)) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        StringReader r = new StringReader(tagString);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                tags.add(new Tag(entry.getKey(), entry.getValue()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void addTags(Object object, Tag ... pTags) {
        if (pTags == null) {
            return;
        }
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.addAll(Arrays.asList(pTags));
    }

    protected static List<Tag> basicGetTags(Object object) {
        if (object instanceof ITagSupport) {
            return ((ITagSupport)object).getTags();
        }
        if (object instanceof IAttributeSupport) {
            ArrayList tags = (ArrayList)((IAttributeSupport)object).getAttribute(ATTR_TAGS);
            if (tags == null) {
                tags = new ArrayList();
                ((IAttributeSupport)object).setAttribute(ATTR_TAGS, tags);
            }
            return tags;
        }
        List tags = TAGS_MAP.computeIfAbsent(object, key -> new ArrayList());
        return tags;
    }

    protected static List<Tag> basicLookupTags(Object object) {
        if (object instanceof ITagSupport) {
            return ((ITagSupport)object).getTags();
        }
        if (object instanceof IAttributeSupport) {
            List tags = (List)((IAttributeSupport)object).getAttribute(ATTR_TAGS);
            return tags;
        }
        List<Tag> tags = TAGS_MAP.get(object);
        return tags;
    }

    public static void configureTags(Object target, IElement pElement) {
        IElement elTags = pElement.element(RESOLVER_NS_TAGS);
        if (elTags != null) {
            Iterator<IElement> itTags = elTags.elementIterator("tag");
            while (itTags.hasNext()) {
                IElement elTag = itTags.next();
                String key = elTag.attributeValue("key", "");
                String value = elTag.attributeValue("value", "true");
                TagTools.addTag(target, key, value);
            }
        }
    }

    public static IStringEvaluator createDetachedResolver(Object target) {
        return new TagResolver(new TagList(TagTools.basicLookupTags(target)));
    }

    public static IStringEvaluator createDetachedResolverTags(Object target) {
        return MapResolver.createStrict(RESOLVER_NS_TAGS, TagTools.createDetachedResolver(target));
    }

    public static IStringEvaluator createResolver(Object target) {
        return new TagResolver(target);
    }

    public static IStringEvaluator createResolverTags(Object target) {
        return MapResolver.createStrict(RESOLVER_NS_TAGS, TagTools.createResolver(target));
    }

    public static void expandArgs(Object target, IArgs args) {
        TagResolver tagResolver = new TagResolver(target);
        MapResolver mapResolver = MapResolver.createStrict(RESOLVER_NS_TAGS, tagResolver);
        TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorateLenient(mapResolver);
        ArgTools.expandDeep(args, evaluator);
    }

    public static Tag getTag(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return null;
        }
        for (Tag tag : tags) {
            if (!key.equals(tag.getKey())) continue;
            return tag;
        }
        return null;
    }

    public static List<Tag> getTagList(Object object) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return EMPTY;
        }
        return new ArrayList<Tag>(tags);
    }

    public static List<Tag> getTagList(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return EMPTY;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag tag : tags) {
            if (!key.equals(tag.getKey())) continue;
            result.add(tag);
        }
        return result;
    }

    public static Object getTagMeta(Object object, String key, String metaKey, Object defaultValue) {
        Tag tag = TagTools.getTag(object, key);
        return TagTools.getTagMeta(tag, metaKey, defaultValue);
    }

    public static Object getTagMeta(Tag tag, String metaKey, Object defaultValue) {
        if (tag == null) {
            return defaultValue;
        }
        Object metaValue = tag.getProperty(metaKey);
        if (metaValue == null) {
            return defaultValue;
        }
        return metaValue;
    }

    public static String getTagValue(Object object, String key, String defaultValue) {
        Tag tag = TagTools.getTag(object, key);
        if (tag == null) {
            return defaultValue;
        }
        return tag.getValue();
    }

    public static List<String> getTagValues(Object object) {
        return TagTools.getTagList(object).stream().map(tag -> tag.getValue()).toList();
    }

    public static List<String> getTagValues(Object object, String key) {
        return TagTools.getTagList(object, key).stream().map(tag -> tag.getValue()).toList();
    }

    public static boolean hasTag(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return false;
        }
        for (Tag tag : tags) {
            if (!key.equals(tag.getKey())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTags(Object object) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return false;
        }
        return !tags.isEmpty();
    }

    public static boolean hasTags(Object object, List<Tag> tags) {
        for (Tag tag : tags) {
            boolean tagFound = false;
            List<Tag> objectTags = TagTools.getTagList(object, tag.getKey());
            for (Tag objectTag : objectTags) {
                if (!tag.equals(objectTag)) continue;
                tagFound = true;
                break;
            }
            if (tagFound) continue;
            return false;
        }
        return true;
    }

    public static Tag parseTag(String definition) throws IOException {
        String key = "";
        String value = "";
        StringReader r = new StringReader(definition);
        Map.Entry<String, String> entry = ReaderTools.readEntry(r, ';');
        if (entry == null) {
            return null;
        }
        if (entry.getKey() == null) {
            return null;
        }
        key = entry.getKey();
        if (entry.getValue() != null) {
            value = entry.getValue();
        }
        return new Tag(key, value);
    }

    public static List<Tag> parseTags(String definition) throws IOException {
        Map.Entry<String, String> entry;
        ArrayList<Tag> result = new ArrayList<Tag>();
        StringReader r = new StringReader(definition);
        while ((entry = ReaderTools.readEntry(r, ';')) != null) {
            if (entry.getKey() == null) continue;
            result.add(new Tag(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static void removeTags(Object object, String key) {
        List<Tag> tags = TagTools.basicLookupTags(object);
        if (tags == null) {
            return;
        }
        Iterator<Tag> it = tags.iterator();
        while (it.hasNext()) {
            Tag tag = it.next();
            if (!key.equals(tag.getKey())) continue;
            it.remove();
        }
    }

    public static void setTag(Object object, String key, String value) {
        TagTools.removeTags(object, key);
        List<Tag> tags = TagTools.basicGetTags(object);
        tags.add(new Tag(key, value));
    }

    public static IArgs toArgs(List<?> tags, String prefix) {
        Args resultArgs = Args.create();
        for (Object tagObject : tags) {
            Tag tag = null;
            if (tagObject instanceof Tag) {
                tag = (Tag)tagObject;
            } else if (tagObject instanceof String) {
                try {
                    tag = TagTools.parseTag((String)tagObject);
                }
                catch (IOException e) {
                    Log.warn("tag cannot be parsed {}", tagObject);
                    continue;
                }
            }
            if (tag == null) continue;
            String key = tag.getKey();
            String value = tag.getValue();
            if (!key.startsWith(prefix)) continue;
            ArgTools.putPath(resultArgs, key.substring(prefix.length()), value);
        }
        return resultArgs;
    }

    public static IArgs toArgs(Object target, String prefix) {
        List<Tag> tags = TagTools.getTagList(target == null ? Zone.getCurrent() : target);
        return TagTools.toArgs(tags, prefix);
    }

    private TagTools() {
    }
}

