/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;

public class StringEncodingTools {
    protected static final String[] TRUSTED_ENCODINGS = new String[]{"IBM00858", "IBM850", "ISO-8859-1", "US-ASCII", "UTF-8", "windows-1250", "windows-1252", "x-MacCentralEurope"};

    public static String[] charsets(boolean trusted) {
        if (trusted) {
            ArrayList<String> available = new ArrayList<String>();
            for (int i = 0; i < TRUSTED_ENCODINGS.length; ++i) {
                String encoding = TRUSTED_ENCODINGS[i];
                try {
                    if (Charset.forName(encoding) == null) continue;
                    available.add(encoding);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return available.toArray(new String[available.size()]);
        }
        Set<String> charsets = Charset.availableCharsets().keySet();
        String[] result = new String[TRUSTED_ENCODINGS.length + charsets.size()];
        System.arraycopy(TRUSTED_ENCODINGS, 0, result, 0, TRUSTED_ENCODINGS.length);
        int i = TRUSTED_ENCODINGS.length;
        for (String encoding : charsets) {
            result[i++] = "[" + encoding + "]";
        }
        return result;
    }

    private StringEncodingTools() {
    }
}

