/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.session;

import de.intarsys.tools.component.ExpirationWatchdog;
import de.intarsys.tools.component.IExpirationSupport;
import de.intarsys.tools.session.ISession;
import de.intarsys.tools.session.ISessionRegistry;
import de.intarsys.tools.session.SessionExpired;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSessionRegistry
implements ISessionRegistry {
    private static final Logger Log = LoggerFactory.getLogger(StandardSessionRegistry.class);
    private final ExpirationWatchdog watchdog = new ExpirationWatchdog(new ExpirationWatchdog.IResourceHolder(){

        @Override
        public void expire(IExpirationSupport resource) {
            StandardSessionRegistry.this.unregister((ISession)resource);
        }

        @Override
        public int getResourceCount() {
            return StandardSessionRegistry.this.sessions.size();
        }

        @Override
        public List<IExpirationSupport> getResources() {
            return new ArrayList<IExpirationSupport>(StandardSessionRegistry.this.sessions.values());
        }
    });
    private final Map<String, ISession> sessions = new ConcurrentHashMap<String, ISession>();

    @Override
    public Stream<ISession> getSessions() {
        return new ArrayList<ISession>(this.sessions.values()).stream();
    }

    @Override
    public ISession lookup(String id) {
        ISession result = this.sessions.get(id);
        if (result == null || result.isExpired()) {
            throw new SessionExpired(id + " expired");
        }
        result.touch();
        return result;
    }

    @Override
    public void register(ISession session) {
        this.sessions.put(session.getId(), session);
        this.watchdog.wake();
        session.touch();
        Log.debug("{} registered {}", (Object)this, (Object)session);
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.watchdog.setCleanupInterval(cleanupInterval);
    }

    @Override
    public void unregister(ISession session) {
        this.sessions.remove(session.getId());
        session.dispose();
        Log.debug("{} unregistered {}", (Object)this, (Object)session);
    }
}

