/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.session;

import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.concurrent.ForwardedThreadLocal;
import de.intarsys.tools.session.IActivityContext;
import de.intarsys.tools.session.StandardActivityContext;

@Singleton
public final class ActivityContext {
    private static final ThreadLocal<IActivityContext> CONTEXT = new ForwardedThreadLocal(){

        @Override
        protected Object initialValue() {
            return new StandardActivityContext();
        }
    };

    public static IActivityContext get() {
        return CONTEXT.get();
    }

    public static void set(IActivityContext value) {
        if (value == null) {
            CONTEXT.remove();
        } else {
            CONTEXT.set(value);
        }
    }

    private ActivityContext() {
    }
}

