/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servicelocator;

import de.intarsys.tools.provider.ProviderTools;
import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceCreationException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolverProvider<T>
implements IServiceResolver<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public T apply(Class<T> lookupClass) {
        return this.findFirstProvider(lookupClass);
    }

    protected T findFirstProvider(Class<T> lookupClass) {
        try {
            this.log.trace("ServiceResolver {} resolve {}", (Object)this, lookupClass);
            Iterator<T> ps = ProviderTools.providers(lookupClass);
            if (ps.hasNext()) {
                return ps.next();
            }
        }
        catch (Throwable e) {
            throw new ServiceCreationException("service creation for " + lookupClass + " failed", e);
        }
        return null;
    }
}

