/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servicelocator;

import de.intarsys.tools.bean.ServiceResolverBeanContainer;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.format.Format;
import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceNotFoundException;
import de.intarsys.tools.servicelocator.ServiceResolverConcreteImplementation;
import de.intarsys.tools.servicelocator.ServiceResolverDefaultImplementation;
import de.intarsys.tools.servicelocator.ServiceResolverDefaultResolver;
import de.intarsys.tools.servicelocator.ServiceResolverProvider;
import de.intarsys.tools.servicelocator.ServiceResolverResolver;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class ServiceLocator {
    private static ServiceLocator Active = new ServiceLocator();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, Object> instances = new ConcurrentHashMap();
    private final Object lock = new Object();
    private final List<IServiceResolver> resolvers = new CopyOnWriteArrayList<IServiceResolver>();
    private final Set<Class<?>> stack = new HashSet();

    public static ServiceLocator get() {
        return Active;
    }

    public static void set(ServiceLocator value) {
        Active = value;
    }

    public ServiceLocator() {
        this.init();
    }

    public void addResolver(IServiceResolver resolver) {
        this.resolvers.add(0, resolver);
    }

    protected <T> T createInstance(Class<T> clazz) {
        for (IServiceResolver singletonResolver : this.resolvers) {
            Object object = singletonResolver.apply(clazz);
            if (object == null) continue;
            return (T)object;
        }
        throw new ServiceNotFoundException("service creation for " + clazz + " failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> clazz) {
        Object object = this.instances.get(clazz);
        if (object == null) {
            Object object2 = this.lock;
            synchronized (object2) {
                object = this.instances.get(clazz);
                if (object == null) {
                    if (this.stack.contains(clazz)) {
                        String msg = Format.simple("recursive service locator lookup for {} in {}", clazz, this.stack);
                        IllegalStateException e = new IllegalStateException(msg);
                        this.log.warn(msg, (Throwable)e);
                        throw e;
                    }
                    try {
                        this.stack.add(clazz);
                        object = this.createInstance(clazz);
                        this.instances.put(clazz, object);
                        this.log.debug("ServiceLocator cached {} with {}", clazz, object);
                    }
                    finally {
                        this.stack.remove(clazz);
                    }
                }
            }
        }
        return (T)object;
    }

    public List<IServiceResolver> getResolvers() {
        return this.resolvers;
    }

    private void init() {
        this.resolvers.add(new ServiceResolverResolver());
        this.resolvers.add(new ServiceResolverBeanContainer());
        this.resolvers.add(new ServiceResolverProvider());
        this.resolvers.add(new ServiceResolverDefaultResolver());
        this.resolvers.add(new ServiceResolverDefaultImplementation());
        this.resolvers.add(new ServiceResolverConcreteImplementation());
    }

    public <T> T lookup(Class<T> clazz) {
        return (T)this.instances.get(clazz);
    }

    public <T> T put(Class<T> clazz, T object) {
        Object old = object == null ? this.instances.remove(clazz) : this.instances.put(clazz, object);
        this.log.debug("ServiceLocator bound {} with {}", clazz, object);
        return clazz.cast(old);
    }

    public <T> T remove(Class<T> clazz) {
        Object removed = this.instances.remove(clazz);
        this.log.debug("ServiceLocator unbound {}", clazz);
        return clazz.cast(removed);
    }

    public boolean removeResolver(IServiceResolver resolver) {
        return this.resolvers.remove(resolver);
    }

    public void resetAll() {
        this.resetServices();
        this.stack.clear();
        this.resolvers.clear();
        this.init();
    }

    public void resetServices() {
        this.instances.clear();
    }
}

