/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.serialize.SerializationContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class StreamSerializationContext
extends SerializationContext {
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public StreamSerializationContext() {
        this.inputStream = null;
        this.outputStream = new ByteArrayOutputStream();
    }

    public StreamSerializationContext(byte[] input) {
        this.inputStream = new ByteArrayInputStream(input);
        this.outputStream = null;
    }

    public StreamSerializationContext(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public StreamSerializationContext(String input) {
        if (input == null) {
            input = "";
        }
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        this.inputStream = new ByteArrayInputStream(data);
        this.outputStream = null;
    }

    public byte[] getBytes() {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.outputStream).toByteArray();
        }
        return new byte[0];
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }
}

