/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.serialize.IDeserializer;
import de.intarsys.tools.stream.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BONDeserializer
implements IDeserializer {
    private final InputStream is;
    private final FastByteArrayOutputStream os = new FastByteArrayOutputStream();
    private boolean isfloat;
    private String charset = "UTF-8";

    public BONDeserializer(InputStream is) {
        this.is = is;
    }

    public BONDeserializer(InputStream is, String charset) {
        this.is = is;
        this.charset = charset;
    }

    @Override
    public Object deserialize() throws IOException {
        this.os.reset();
        int i = this.is.read();
        while (this.isWhitespace(i)) {
            i = this.is.read();
        }
        if (i == -1) {
            return null;
        }
        if (i >= 48 && i <= 57 || i == 43 || i == 46 || i == 45) {
            this.isfloat = i == 46;
            this.os.write(i);
            return this.deserializeNumber();
        }
        if (this.isLetter(i)) {
            this.os.write(i);
            String token = this.deserializeToken();
            if ("null".equals(token)) {
                return null;
            }
            if ("true".equals(token)) {
                return true;
            }
            if ("false".equals(token)) {
                return false;
            }
            throw new IOException("unexpected token '" + token + "'");
        }
        if (i == 34) {
            return this.deserializeString();
        }
        if (i == 64) {
            return this.deserializeBase64();
        }
        if (i == 35) {
            return this.deserializeBinary();
        }
        throw new IOException("unexpected character " + (char)i + " (" + i + ")");
    }

    protected Object deserializeBase64() throws IOException {
        int i = this.is.read();
        while (i != -1 && i != 64) {
            this.os.write(i);
            i = this.is.read();
        }
        return Base64.decode(this.os.toByteArray(), 0, this.os.size());
    }

    protected Object deserializeBinary() throws IOException {
        int i = this.is.read();
        while (i != -1 && (i != 35 || (i = this.is.read()) == 35)) {
            this.os.write(i);
            i = this.is.read();
        }
        return this.os.getBytes();
    }

    protected Object deserializeNumber() throws IOException {
        int i = this.is.read();
        while (i != -1 && (this.isNumber(i) || i == 46)) {
            this.isfloat = this.isfloat || i == 46;
            this.os.write(i);
            i = this.is.read();
        }
        String strValue = new String(this.os.getBytes(), 0, this.os.size());
        if (this.isfloat) {
            return Float.valueOf(Float.parseFloat(strValue));
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            return Long.parseLong(strValue);
        }
    }

    protected String deserializeString() throws IOException {
        int i = this.is.read();
        while (i != -1) {
            if (i == 92) {
                i = this.is.read();
                if (i == -1) break;
                this.os.write(i);
                i = this.is.read();
                continue;
            }
            if (i == 34) break;
            this.os.write(i);
            i = this.is.read();
        }
        return new String(this.os.getBytes(), 0, this.os.size(), this.getCharset());
    }

    protected String deserializeToken() throws IOException {
        int i = this.is.read();
        while (i != -1 && this.isLetter(i)) {
            this.os.write(i);
            i = this.is.read();
        }
        return new String(this.os.getBytes(), 0, this.os.size());
    }

    public String getCharset() {
        return this.charset;
    }

    protected boolean isLetter(int i) {
        return i >= 97 && i <= 122 || i >= 65 && i <= 90;
    }

    protected boolean isNumber(int i) {
        return i >= 48 && i <= 57;
    }

    protected boolean isWhitespace(int i) {
        return i == 32 || i == 9 || i == 10;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

