/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.sax;

import de.intarsys.tools.sax.ISAXElementHandler;
import de.intarsys.tools.sax.SAXAbstractElementHandler;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DelegatingElementHandler
extends SAXAbstractElementHandler {
    private ISAXElementHandler delegate;
    private Object result;
    private Map<String, String> aliases = new HashMap<String, String>();
    private final String handlerAttribute;

    public DelegatingElementHandler() {
        this.handlerAttribute = "deserializer";
    }

    public DelegatingElementHandler(String handlerAttribute) {
        this.handlerAttribute = handlerAttribute;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.delegate.characters(ch, start, length);
    }

    protected ISAXElementHandler createNestedHandler(String handlerClass) throws SAXException {
        String tempClass = this.aliases.get(handlerClass);
        if (tempClass == null) {
            tempClass = handlerClass;
        }
        try {
            Class<?> handlerClazz = Class.forName(tempClass);
            ISAXElementHandler handler = (ISAXElementHandler)handlerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return handler;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endChildElement(ISAXElementHandler element) throws SAXException {
        this.delegate.endChildElement(element);
        this.result = element.getResult();
    }

    @Override
    public void endElement(String pUri, String local, String name) throws SAXException {
        this.delegate.endElement(pUri, local, name);
    }

    public String getHandlerAttribute() {
        return this.handlerAttribute;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void initialize(String pUri, String local, String name, Attributes attrs) throws SAXException {
        super.initialize(pUri, local, name, attrs);
        String nestedHandler = attrs.getValue(this.getHandlerAttribute());
        this.delegate = this.createNestedHandler(nestedHandler);
        this.delegate.setContextHandler(this.getContextHandler());
        this.delegate.setParent(this.getParent());
        this.delegate.initialize(pUri, local, name, attrs);
    }

    @Override
    public void processAttributes(Attributes attrs) throws SAXException {
        this.delegate.processAttributes(attrs);
    }

    public void registerAlias(String alias, String name) {
        this.aliases.put(alias, name);
    }

    @Override
    public void startChildElement(ISAXElementHandler element) throws SAXException {
        super.startChildElement(element);
        this.delegate.startChildElement(element);
    }

    @Override
    public void started() throws SAXException {
        super.started();
        this.delegate.started();
    }

    @Override
    public ISAXElementHandler startElement(String pUri, String local, String name, Attributes attrs) throws SAXException {
        return this.delegate.startElement(pUri, local, name, attrs);
    }

    public void unregisterAlias(String alias) {
        this.aliases.remove(alias);
    }
}

