/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderTools {
    private static final Logger Log = LoggerFactory.getLogger(ClassLoaderTools.class);

    public static void collectURLsFile(List<URL> urls, File file) {
        URL url = ClassLoaderTools.toURL(file);
        if (url != null) {
            Log.debug("collectURLsFile({})", (Object)url);
            urls.add(url);
        }
    }

    public static void collectURLsPath(List<URL> urls, File baseDir, String path) {
        if (!StringTools.isEmpty(path)) {
            String[] names;
            Log.debug("collectURLsClasspath({}, {})", (Object)baseDir, (Object)path);
            for (String name : names = path.split(";")) {
                File file = new File(name);
                if (!file.isAbsolute()) {
                    file = new File(baseDir, name);
                }
                ClassLoaderTools.collectURLsFile(urls, file);
            }
        }
    }

    public static void collectURLsScan(List<URL> urls, File directory, final List<String> exclude) {
        Log.debug("collectURLsScan({})", (Object)directory);
        File[] jarFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isFile() && path.canRead() && path.getName().toLowerCase().endsWith(".jar") && !exclude.contains(path.getName());
            }
        });
        if (jarFiles != null) {
            for (File file : jarFiles) {
                ClassLoaderTools.collectURLsFile(urls, file);
            }
        }
    }

    public static void collectURLsScan(List<URL> urls, File baseDir, String scanPath, String scanExclude) {
        if (!StringTools.isEmpty(scanPath)) {
            Log.debug("collectURLsScan({}, {}, {})", new Object[]{baseDir, scanPath, scanExclude});
            String[] names = scanPath.split(";");
            List<Object> exclude = StringTools.isEmpty(scanExclude) ? new ArrayList() : Arrays.asList(scanExclude.split(";"));
            for (String name : names) {
                File file = new File(name);
                if (!file.isAbsolute()) {
                    file = new File(baseDir, name);
                }
                ClassLoaderTools.collectURLsScan(urls, file, exclude);
            }
        }
    }

    public static ClassLoader createClassLoader(ClassLoader parent, File ... files) {
        return new URLClassLoader(ClassLoaderTools.toURLs(files), parent);
    }

    public static ClassLoader createClassLoader(ClassLoader parent, File baseDir, String classpath, String classpathScan, String classpathScanExclude) {
        ArrayList<URL> urls = new ArrayList<URL>();
        ClassLoaderTools.collectURLsPath(urls, baseDir, classpath);
        ClassLoaderTools.collectURLsScan(urls, baseDir, classpathScan, classpathScanExclude);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    public static ClassLoader createClassLoader(ClassLoader parent, List<URL> urls) {
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    public static ClassLoader defaultClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static void extendClassLoader(ClassLoader classLoader, URL url) {
        try {
            Method addUrl;
            try {
                addUrl = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            }
            catch (Exception e) {
                addUrl = classLoader.getClass().getDeclaredMethod("addAppURL", URL.class);
            }
            addUrl.setAccessible(true);
            addUrl.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot extend classloader", e);
        }
    }

    public static URL[] parseURLs(String path) {
        if (StringTools.isEmpty(path)) {
            return null;
        }
        String[] names = path.split(";");
        return ClassLoaderTools.toURLs(names);
    }

    public static URL toURL(File file) {
        if (file == null) {
            return null;
        }
        URL url = null;
        try {
            url = file.getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            if (file.isFile()) {
                try {
                    url = new URL("file", "", file.getAbsolutePath());
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException();
                }
            }
            try {
                url = new URL("file", "", file.getAbsolutePath() + "/");
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException();
            }
        }
        return url;
    }

    public static URL[] toURLs(File ... files) {
        return (URL[])Arrays.stream(files).map(file -> ClassLoaderTools.toURL(file)).toArray(URL[]::new);
    }

    public static URL[] toURLs(String ... paths) {
        return (URL[])Arrays.stream(paths).map(path -> ClassLoaderTools.toURL(new File((String)path))).toArray(URL[]::new);
    }

    private ClassLoaderTools() {
    }
}

