/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.OutputStream;

public class RandomAccessOutputStream
extends OutputStream {
    private final IRandomAccess randomAccess;
    private long offset;

    public RandomAccessOutputStream(IRandomAccess randomAccess) {
        this(randomAccess, 0L);
    }

    public RandomAccessOutputStream(IRandomAccess randomAccess, long offset) {
        this.randomAccess = randomAccess;
        this.offset = offset;
    }

    @Override
    public void close() throws IOException {
        this.randomAccess.flush();
    }

    @Override
    public void flush() throws IOException {
        this.randomAccess.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.randomAccess.seek(this.offset);
        this.randomAccess.write(b);
        this.offset += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.randomAccess.seek(this.offset);
        this.randomAccess.write(b, off, len);
        this.offset += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.randomAccess.seek(this.offset);
        this.randomAccess.write(b);
        ++this.offset;
    }
}

