/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.presentation;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.message.MessageBundleFactory;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.IClassLoaderSupport;

public class PresentationMixin
implements IPresentationSupport {
    private static final Object UNDEFINED = new Object();
    private final Object object;
    private Object label;
    private Object description;
    private Object tip;
    private Object iconName = UNDEFINED;
    private IMessageBundle messageBundle;
    private String codePrefix;
    private Object[] formatArgs;

    public PresentationMixin(Object object) {
        this.object = object;
    }

    protected String basicGetDescription() {
        String key;
        IMessageBundle bundle = this.getMessageBundle();
        String pattern = bundle.getPattern(key = this.getCodePrefix() + ".description");
        if (pattern != null) {
            this.description = bundle.format(pattern, this.getFormatArgs());
            return (String)this.description;
        }
        return this.getTip();
    }

    protected String basicGetIconName() {
        String key;
        IMessageBundle bundle = this.getMessageBundle();
        String pattern = bundle.getPattern(key = this.getCodePrefix() + ".icon");
        if (pattern != null) {
            this.iconName = bundle.format(pattern, this.getFormatArgs());
            return (String)this.iconName;
        }
        this.iconName = null;
        return (String)this.iconName;
    }

    protected String basicGetLabel() {
        String key;
        IMessageBundle bundle = this.getMessageBundle();
        String pattern = bundle.getPattern(key = this.getCodePrefix() + ".label");
        if (pattern != null) {
            this.label = bundle.format(pattern, this.getFormatArgs());
            return (String)this.label;
        }
        return key;
    }

    protected String basicGetTip() {
        String key;
        IMessageBundle bundle = this.getMessageBundle();
        String pattern = bundle.getPattern(key = this.getCodePrefix() + ".tip");
        if (pattern != null) {
            this.tip = bundle.format(pattern, this.getFormatArgs());
            return (String)this.tip;
        }
        return this.getLabel();
    }

    public void configure(IElement element) throws ConfigurationException {
        if (element == null) {
            return;
        }
        IAttribute attribute = element.attribute("icon");
        if (attribute != null) {
            this.setIconName(attribute.getData());
        }
        if ((attribute = element.attribute("label")) != null) {
            this.setLabel(attribute.getData());
        }
        if ((attribute = element.attribute("tip")) != null) {
            this.setTip(attribute.getData());
        }
        if ((attribute = element.attribute("description")) != null) {
            this.setDescription(attribute.getData());
        }
    }

    protected IMessageBundle createMessageBundle() {
        if (this.object instanceof IMessageBundleSupport) {
            return ((IMessageBundleSupport)this.object).getMessageBundle();
        }
        if (this.object instanceof IClassLoaderSupport) {
            return MessageBundleFactory.get().getMessageBundle(this.getMessageBundleName(), ((IClassLoaderSupport)this.object).getClassLoader());
        }
        return MessageTools.getMessageBundle(this.getMessageBundleClass());
    }

    public String getCodePrefix() {
        if (this.codePrefix == null) {
            return ClassTools.getUnqualifiedName(this.getMessageBundleClass());
        }
        return this.codePrefix;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.basicGetDescription();
        }
        if (this.description instanceof IMessage) {
            return ((IMessage)this.description).getString();
        }
        return (String)this.description;
    }

    public Object[] getFormatArgs() {
        return this.formatArgs;
    }

    @Override
    public String getIconName() {
        if (this.iconName == UNDEFINED) {
            return this.basicGetIconName();
        }
        if (this.iconName instanceof IMessage) {
            return ((IMessage)this.iconName).getString();
        }
        return (String)this.iconName;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            return this.basicGetLabel();
        }
        if (this.label instanceof IMessage) {
            return ((IMessage)this.label).getString();
        }
        return (String)this.label;
    }

    public IMessageBundle getMessageBundle() {
        if (this.messageBundle == null) {
            this.messageBundle = this.createMessageBundle();
        }
        return this.messageBundle;
    }

    protected Class getMessageBundleClass() {
        return this.object.getClass();
    }

    protected String getMessageBundleName() {
        return MessageTools.getBundleName(this.object.getClass());
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public String getTip() {
        if (this.tip == null) {
            return this.basicGetTip();
        }
        if (this.tip instanceof IMessage) {
            return ((IMessage)this.tip).getString();
        }
        return (String)this.tip;
    }

    public boolean isLabelDefined() {
        String key;
        if (this.label != null) {
            return true;
        }
        IMessageBundle bundle = this.getMessageBundle();
        String pattern = bundle.getPattern(key = this.getCodePrefix() + ".label");
        return pattern != null;
    }

    public void setCodePrefix(String codePrefix) {
        this.codePrefix = codePrefix;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    public void setFormatArgs(Object[] formatArgs) {
        this.formatArgs = formatArgs;
    }

    public void setIconName(Object iconName) {
        this.iconName = iconName;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public void setMessageBundle(IMessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public void setTip(Object tip) {
        this.tip = tip;
    }
}

