/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectmodel;

import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.objectmodel.FunctorMethod;
import de.intarsys.tools.objectmodel.IClassSelector;
import de.intarsys.tools.objectmodel.IMethod;
import de.intarsys.tools.objectmodel.ObjectModelTools;
import jakarta.annotation.PostConstruct;

public class ObjectModelMethodDeclaration {
    private IFunctor functor;
    private String implementor;
    private String methodName;
    private String modifiers;

    public IFunctor getFunctor() {
        return this.functor;
    }

    public String getImplementor() {
        return this.implementor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    @PostConstruct
    public void install() {
        try {
            IClassSelector selector = ObjectModelTools.createSelector(this.getImplementor());
            FunctorMethod method = new FunctorMethod(this.getMethodName(), this.functor);
            method.setModifiers(this.getModifiers());
            method.setDeclaringClass(ObjectModelTools.lookupClass(selector));
            ObjectModelTools.registerMethod(selector, (IMethod)method);
        }
        catch (Exception e) {
            throw new InitializationException(e);
        }
    }

    public void setFunctor(IFunctor functor) {
        this.functor = functor;
    }

    public void setImplementor(String implementor) {
        this.implementor = implementor;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setModifiers(String modifiers) {
        this.modifiers = modifiers;
    }
}

