/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.IntervalIterator;
import de.intarsys.tools.number.NumberWrapper;
import java.util.Iterator;

public class NumberInterval
extends NumberWrapper {
    public static final char SEPARATOR = '-';
    private Number from;
    private Number to;

    public boolean add(Object arg0) {
        if (arg0 instanceof Number) {
            Number n = (Number)arg0;
            if (n.doubleValue() < this.from.doubleValue()) {
                this.from = n.doubleValue();
            } else if (n.doubleValue() > this.to.doubleValue()) {
                this.to = n.doubleValue();
            }
            return true;
        }
        if (arg0 instanceof NumberWrapper) {
            NumberWrapper wrapper = (NumberWrapper)arg0;
            if (wrapper.getMin() < this.getMin()) {
                this.from = wrapper.getMin();
            }
            if (wrapper.getMax() > this.getMax()) {
                this.to = wrapper.getMax();
            }
        }
        throw new IllegalArgumentException("Only objects of type Number or NumberWrapper are supported.");
    }

    public Number getFrom() {
        return this.from;
    }

    @Override
    public double getMax() {
        return this.to.doubleValue();
    }

    @Override
    public double getMin() {
        return this.from.doubleValue();
    }

    public Number getTo() {
        return this.to;
    }

    @Override
    public NumberWrapper increment(int i) {
        this.from = this.getFrom().intValue() + i;
        this.to = this.getTo().intValue() + i;
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.to == null || this.from == null) {
            return true;
        }
        return this.from.intValue() > this.to.intValue();
    }

    @Override
    public Iterator iterator() {
        return new IntervalIterator(this.from, this.to);
    }

    public void setFrom(Number newFrom) {
        this.from = newFrom;
    }

    public void setTo(Number newTo) {
        this.to = newTo;
    }

    @Override
    public int size() {
        return (int)Math.round(this.to.doubleValue() - this.from.doubleValue()) + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFrom());
        sb.append('-');
        sb.append(this.getTo());
        return sb.toString();
    }
}

